package com.pcloud.book.group.enums;

/**
 * 资源页开关配置
 */
public enum ResourcePageSwitchConfigEnum implements IMaskFlag {
    SHOW_SELF(0, "开启展示我的页面"),
    /**
     * 默认开启收藏
     */
    SHOW_COLLECT(1, "开启展示收藏", true),
    /**
     * 默认开启分享
     */
    SHOW_SHARE(2, "开启展示分享", true),

    NEW_EDITOR(3, "新版编辑器", false),
    ;


    private final int flag;
    private final String desc;
    private final boolean defaultState;

    ResourcePageSwitchConfigEnum(int flag, String desc) {
        this(flag, desc, false);
    }

    ResourcePageSwitchConfigEnum(int flag, String desc, boolean defaultState) {
        this.flag = flag;
        this.desc = desc;
        this.defaultState = defaultState;
    }

    @Override
    public int getFlag() {
        return 1 << flag;
    }

    @Override
    public boolean defaultState() {
        return this.defaultState;
    }


    public String getDesc() {
        return desc;
    }

}
