package com.pcloud.book.group.facade;

import com.pcloud.book.group.entity.MultiChannelContentItem;
import com.pcloud.book.group.biz.MultiChannelContentItemBiz;
 import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import io.swagger.annotations.ApiOperation;

/**
 * (MultiChannelContentItem)表控制层
 *
 * @author wubo 
 * @since 2022-06-06 19:12:16
 */
@RestController("multiChannelContentItemFacade")
@RequestMapping("multiChannelContentItem")
public class MultiChannelContentItemFacade {
    
    @Autowired
    private MultiChannelContentItemBiz multiChannelContentItemBiz;

    
    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(multiChannelContentItemBiz.getById(id));
    }
    
    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@RequestHeader("token") String token, 
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage, 
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage) 
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(multiChannelContentItemBiz.getList(currentPage, numPerPage));
    }
    
    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@RequestHeader("token") String token, @RequestBody MultiChannelContentItem multiChannelContentItem)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(multiChannelContentItemBiz.insert(multiChannelContentItem));
    }
    
    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@RequestHeader("token") String token,@RequestBody MultiChannelContentItem multiChannelContentItem) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        multiChannelContentItemBiz.update(multiChannelContentItem);
        return new ResponseDto<>();
    }
    
    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == id) {
            throw BizException.PARAM_DELETION;
        }
        multiChannelContentItemBiz.deleteById(id);
        return new ResponseDto<>();
    }
    
    @ApiOperation("软删除")
    @GetMapping("softDeleteById")
    public ResponseDto<?> softDeleteById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == id) {
            throw BizException.PARAM_DELETION;
        }
        multiChannelContentItemBiz.softDeleteById(id);
        return new ResponseDto<>();
    }

}
