package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletNewsDao;
import com.pcloud.book.applet.entity.AppletNews;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 小程序资讯
 */
@Component
public class AppletNewsDaoImpl extends BaseDaoImpl<AppletNews> implements AppletNewsDao {

    @Override
    public List<AppletNews> getByNewsClassifyId(Long newsClassifyId) {
        return getSessionTemplate().selectList(getStatement("getByNewsClassifyId"), newsClassifyId);
    }

    @Override
    public void updateNewsShowState(AppletNews appletNews) {
        getSessionTemplate().update(getStatement("updateNewsShowState"),appletNews);
    }
}
