package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletUserBookcaseDao;
import com.pcloud.book.applet.entity.AppletUserBookcase;
import com.pcloud.book.applet.entity.AppletUserClickRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 小程序用户书架
 */
@Component
public class AppletUserBookcaseDaoImpl extends BaseDaoImpl<AppletUserBookcase> implements AppletUserBookcaseDao {


    @Override
    public void insertClickRecord(AppletUserClickRecord appletUserClickRecord) {
        getSessionTemplate().insert(getStatement("insertClickRecord"),appletUserClickRecord);
    }

    @Override
    public Integer getUserClickServerCount(Long wechatUserId, Long bookId, Long channelId, Long adviserId,List<Long> serveIds, String fromType) {
        Map<String,Object> map = new HashMap<>();
        map.put("wechatUserId", wechatUserId);
        map.put("bookId", bookId);
        map.put("channelId", channelId);
        map.put("adviserId", adviserId);
        map.put("list",serveIds);
        map.put("fromType", fromType);
        return getSessionTemplate().selectOne(getStatement("getUserClickServerCount"), map);
    }

    @Override
    public String getMinClickTime(Long wechatUserId, Long bookId, Long channelId, Long adviserId,List<Long> serveIds, String fromType) {
        Map<String,Object> map = new HashMap<>();
        map.put("wechatUserId", wechatUserId);
        map.put("bookId", bookId);
        map.put("channelId", channelId);
        map.put("adviserId", adviserId);
        map.put("list",serveIds);
        map.put("fromType", fromType);
        return getSessionTemplate().selectOne(getStatement("getMinClickTime"),map);
    }
}
