package com.pcloud.book.custom.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CustomPlan {

    private Integer id;

    private String planNumber;

    private String planName;

    private String createUserName;

    private String description;

    private Integer openFeedback;

    private Integer paperId;

    private String paperTitle;

    private String paperDesc;

    private Integer useState;

    private String pdfUrl;

    private String h5Url;

    private String previewQrcodeUrl;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    private Integer suggestionCount;

    private String confirmFeedbackReply;

    @ApiModelProperty("个人号类型")
    private Integer robotType;

    @ApiModelProperty("个人号类型名称")
    private String robotTypeName;

    @ApiModelProperty("阅读类型1轻松2高效3深度")
    private Integer readType;

    @ApiModelProperty("书Id")
    private Long bookId;

    @ApiModelProperty("权益图片")
    private String rightsPic;

    @ApiModelProperty("按钮名称")
    private String buttonName;

    @ApiModelProperty("书籍名称")
    private String bookName;
}