package com.pcloud.book.keywords.vo;

import com.pcloud.common.entity.BaseRequestVO;
import com.pcloud.common.utils.string.StringUtil;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author lily
 * @date 2019/4/24 14:41
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString(callSuper = true)
public class SetKeywordVO extends BaseRequestVO {

    private static final long serialVersionUID = 969101052142345874L;
    @ApiModelProperty("社群码标识")
    private Long bookGroupId;

    @ApiModelProperty("分类标识")
    private Long classifyId;

    @ApiModelProperty("设置类型 0 按书  1 按分类")
    private Integer setType;

    @ApiModelProperty("关键词")
    private String keywords;

    @ApiModelProperty("渠道id")
    private Long channelId;

    @ApiModelProperty("是否仓库词（1：是  0：否）")
    private Integer isWarehouse;

    @ApiModelProperty("仓库词id")
    private Long warehouseId;

    @ApiModelProperty("引导语")
    private String guide;

    @ApiModelProperty("匹配规则")
    private Integer matchingRule;

    @ApiModelProperty("回复类型")
    private Integer replyType;

    @ApiModelProperty("服务标识")
    private Long serveId;

    @ApiModelProperty("服务类型")
    private String serveType;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("图片地址")
    private String picUrl;

    @ApiModelProperty("链接地址")
    private String linkUrl;

    @ApiModelProperty("类型")
    private String typeCode;

    @ApiModelProperty("描述信息")
    private String description;

    @ApiModelProperty("是否加入仓库")
    private Integer addWarehouse;

    public Boolean check() {
        return 4 == this.getReplyType() && (null == this.getServeId() || StringUtil.isBlank(this.getServeType()));
    }

}
