package com.pcloud.book.personalstage.biz;

import com.pcloud.book.personalstage.dto.LinkClickRecordDTO;
import com.pcloud.book.personalstage.dto.EndServiceJumpNextDTO;
import com.pcloud.book.personalstage.dto.PersonalStageJumpDto;
import com.pcloud.book.personalstage.dto.PlanJumpNextDTO;
import com.pcloud.book.personalstage.dto.TimeJumpNextDTO;
import com.pcloud.book.personalstage.enums.JumpTypeEnum;
import com.pcloud.book.personalstage.vo.request.CreateStageJumpRequestVO;
import com.pcloud.book.personalstage.vo.request.UpdateStageJumpRequestVO;
import com.pcloud.common.core.mq.DelayQueueDTO;
import com.pcloud.common.page.PageBeanNew;

import java.util.Map;

public interface PersonalStageJumpBiz {
    /**
     * 新建阶段跳转
     * @param vo
     */
    void createPersonalStageJump(CreateStageJumpRequestVO vo);

    /**
     * 修改阶段跳转
     * @param vo
     */
    void updatePersonalStageJump(UpdateStageJumpRequestVO vo);

    PageBeanNew getJumpList(Long personalStageId, Integer currentPage, Integer numPerPage);

    PersonalStageJumpDto getJump(Long jumpId);

    void deleteJump(Long jumpId);

    Long updateEmailStatus(Long jumpId, Integer openEmail);

    /**
     * 处理用户跳转逻辑
     * 用户的消息状态
     * @return  false:未能跳转到下个阶段，需要后续的其它处理；
     *          true:命中关键字，已经跳转到下个阶段，无需后续处理；
     */
    Boolean handlePersonalStageJump(String userWxId, String robotWxId, String content, JumpTypeEnum jumpTypeEnum);

    /**
     * 跳转到之前的阶段，清除用户填写需求单记录
     * @param personalStageId
     * @param afterPersonalStageId
     * @param userWxId
     * @param robotId
     */
    public void dealPaperRecord(Long personalStageId, Long afterPersonalStageId, String userWxId, String robotId);

    void dealDelayLinkup(DelayQueueDTO dto);

    /**
     * 处理用户提交表单阶段跳转
     * @param userWxId
     * @param robotWxId
     * @param paperId
     * @return
     */
    boolean handlePersonalStagePaperJump(String userWxId, String robotWxId, Long paperId, String emailContent);

    void sendPaperEmail(String userWxId, String robotWxId, String emailContent);

    /**
     * 获取阶段设置期间用户输入的需求单信息
     * @param robotWxId
     * @param userWxId
     * @return
     */
    Map<String, Object> getUserInputPaperInfo(String robotWxId, String userWxId);

    /**
     * 进度单发送时添加未点链接回复延迟
     */
    public void addProgressDelay(String userWxId, String robotWxId, String ip, Integer personalStageProgress1);

    /**
     * 添加点击记录
     * @param linkClickRecordDTO
     */
    public void addLinkClickRecord(LinkClickRecordDTO linkClickRecordDTO);

    /**
     * 处理进度单延迟
     * @param dto
     */
    void delayProgress(DelayQueueDTO dto);

    /**
     * 添加需求定制单延迟
     * @param userWxId
     * @param robotWxId
     * @param ip
     * @param paperId
     */
    public void addPaperDelay(String userWxId, String robotWxId, String ip, Long paperId);

    /**
     * 处理需求单延迟
     * @param dto
     */
    void delayPaper(DelayQueueDTO dto);

    Boolean getHasEndServiceJump(Long personalStageId);

    void endServiceJumpNext(EndServiceJumpNextDTO endServiceJumpNextDTO);

    void planJumpNext(PlanJumpNextDTO planJumpNextDTO);

    void setDelayTimeJump(TimeJumpNextDTO timeJumpNextDTO);

    void dealDelayTimeJump(DelayQueueDTO dto);

    /**
     * 删除用户的需求单记录
     * @param robotId
     * @param userWxId
     */
    public void deletePaperRecord(String robotId, String userWxId);
}
