package com.pcloud.book.weixinclock.dao.impl;

import com.pcloud.book.weixinclock.dao.WeixinClockUserCouponDao;
import com.pcloud.book.weixinclock.entity.WeixinClockUserCoupon;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Describe: 微信群打卡用户优惠dao实现类
 * @Author: zhangdongwei
 * @Date: Create on 9:25 2019/11/19 0019
 */
@Repository("weixinClockUserCouponDao")
public class WeixinClockUserCouponDaoImpl extends BaseDaoImpl<WeixinClockUserCoupon> implements WeixinClockUserCouponDao {
    @Override
    public WeixinClockUserCoupon getByGroupAndUser(String wxGroupId, Long wechatUserId) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxGroupId", wxGroupId);
        map.put("wechatUserId", wechatUserId);
        return super.sqlSessionTemplate.selectOne(getStatement("getByGroupAndUser"),map);
    }

    @Override
    public void updateWechatUserId(String wxUserId, Long wechatUserId) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxUserId", wxUserId);
        map.put("wechatUserId", wechatUserId);
        super.sqlSessionTemplate.update(getStatement("updateWechatUserId"),map);
    }

    @Override
    public List<WeixinClockUserCoupon> getNoWechatUserId() {
        return super.sqlSessionTemplate.selectList(getStatement("getNoWechatUserId"));
    }
}
