package com.pcloud.book.book.biz;

import com.pcloud.book.book.entity.BookLabel;
import com.pcloud.book.book.vo.BookLabelVO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

public interface BookLabelBiz {

    /**
     * 申请新增标签
     * @param bookLabel
     * @param systemCode
     */
    void applyBookLabel(BookLabel bookLabel, String systemCode);

    /**
     * 书刊标签审核
     */
    void auditBookLabel(BookLabelVO bookLabelVO);

    /**
     * 标签删除
     * @param labelId
     */
    void deleteById(Long labelId);

    /**
     * 修改排序值
     * @param labelId
     * @param seq
     */
    void updateLabelSeq(Long labelId, Integer seq);

    /**
     * 审核通过的标签列表
     * @param labelType
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<BookLabelVO> listAuditPassBookLabel(Integer labelType, Integer currentPage, Integer numPerPage);

    /**
     * 标签管理列表
     * @param labelType
     * @param currentPage
     * @param numPerPage
     * @param name
     * @param startTime
     * @param endTime
     * @return
     */
    PageBeanNew<BookLabelVO> listApplyBookLabel(Integer labelType, Integer currentPage, Integer numPerPage,
                                                String name, String startTime, String endTime, Integer auditState);

    Map<Long,String> getLabelMapByIds(List<Long> labelIds);
}
