package com.pcloud.book.mq.topic;

import com.pcloud.book.book.biz.BookAdviserBiz;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.usercenter.common.enums.ResourceEnum;
import com.pcloud.usercenter.system.entity.ExtraSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @描述： 选择默认渠道
 */
@Component("chooseDefaultChannelListener")
@RabbitListener(queues = MQTopicConumer.CHOOSE_DEFAULT_CHANNEL)
public class ChooseDefaultChannelListener{
    @Autowired
    private BookAdviserBiz bookAdviserBiz;
    private static final Logger LOGGER = LoggerFactory.getLogger(ChooseDefaultChannelListener.class);

    /**
     * 选择默认渠道Topic
     */
    @RabbitHandler
    @ParamLog("选择默认渠道Topic")
    public void onMessage(ExtraSetting extraSetting) {
        if (extraSetting == null) {
            return;
        }
        try {
            if (!ResourceEnum.APP.code.equals(extraSetting.getResourceId())) {
                bookAdviserBiz.createDefaultBook(extraSetting.getOptionTarget(), extraSetting.getPartyId());
            }
        } catch (BizException e) {
            LOGGER.warn("生成默认图书失败,<ERROR>:" + e.getMessage(), e);
            return;
        } catch (Exception e) {
            LOGGER.error("生成默认图书失败,<ERROR>:" + e.getMessage(), e);
            return;
        }
    }
}
