package com.pcloud.book.rightsSetting.dao.impl;

import com.pcloud.book.rightsSetting.dao.RightsItemGroupDao;
import com.pcloud.book.rightsSetting.dto.ReadTypeCountDTO;
import com.pcloud.book.rightsSetting.entity.RightsItemGroup;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.rightsSetting.dao.impl.RightsItemGroupDaoImpl
 * @Author ruansiyuan
 * @Description 权益配套资料分组数据实现层
 * @Date 2020/4/26 16:27
 * @Version 1.0
 **/
@Component("rightsItemGroupDao")
public class RightsItemGroupDaoImpl extends BaseDaoImpl<RightsItemGroup> implements RightsItemGroupDao {

    @Override
    public Integer batchInsert(List<RightsItemGroup> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"),list);
    }

    @Override
    public void deleteByRightsSettingId(Long rightsSettingId) {
        super.getSqlSession().delete(getStatement("deleteByRightsSettingId"),rightsSettingId);
    }

    @Override
    public List<RightsItemGroup> getListByRightSettingId(Long rightsSettingId, Integer readType) {
        Map<String,Object>map = new HashMap<>();
        map.put("rightsSettingId",rightsSettingId);
        map.put("readType",readType);
        return super.getSqlSession().selectList(getStatement("getListByRightSettingId"),map);
    }

    @Override
    public ReadTypeCountDTO getCount4Group(Long rightsSettingId) {
        return getSessionTemplate().selectOne(getStatement("getCount4Group"),rightsSettingId);
    }
}