/**
 * 
 */
package com.pcloud.common.core.constant;

/**
 * 
 * 
 * @author：songx
 * @date：2017年2月27日,下午4:29:06
 *
 * 使用RabbitMQ需要去MqQueueConstant中声明队列名称，枚举的第二个值将不再使用,第一个值正常使用
 * modify by songx at 2018-08-22
 */
public enum ConvertEnum {

	/**
	 * 应用转码
	 */
	APP("APP", "convert2App"),

	/**
	 * 资源中心转码
	 */
	RESOURCE("RESOURCE", "convert2Resource"),

	/**
	 * 报名时的视频转换
	 */
	MATCH("MATCH", "convert2Resource"),

	/**
	 * 资源中心即时转换
	 */
	INSTANT_RESOURCE("INSTANT_RESOURCE", "convert2Resource"),

	/**
	 * 报名应用
	 */
	MATCH_APP("MATCH_APP", "convert2MatchApp"),

	/**
	 * 内容中心
	 */
	CONTENT("CONTENT", "convert2Content"),

	/**
	 * 内容中心->题库：文件记忆功能
	 */
	PRETEST_FILEMEMORY("PRETEST_FILEMEMORY", "convert2PretestFilememory"),

	/**
	 * 小游戏
	 */
	RAYSTASK("RAYSTASK", "convert2Raystask"),

	/**
	 * 圈子应用
	 */
	GROUP_APP("GROUP_APP", "convert2GroupApp"),

	/**
	 * 投票应用
	 */
	VOTE_APP("VOTE_APP", "convert2VoteApp"),

	/**
	 * 教育表格应用
	 */
	EF_APP("EF_APP", "convert2EfApp"),

	/**
	 * 测试工具
	 */
	TEST_APP("TEST_APP", "convert2TestApp"),

	/**
	 * 直播工具
	 */
	LIVE_APP("LIVE_APP", "convert2LiveApp"),

	/**
	 * 视频课
	 */
	VIDEO_LESSON("VIDEO_LESSON", "convert2VideoLesson"),

    /**
     * 音频课
     */
    AUDIO_LESSON("AUDIO_LESSON", "convert2AudioLesson"),

    /**
     * 音频纯听
     */
    AUDIO_LISTEN("AUDIO_LISTEN", "convert2AudioListen");

    /**
     * 值
     */
    public final String value;

	/**
	 * 模板名称
	 */
	public final String jmsTemplate;

	/**
	 * 构造
	 * 
	 * @param value
	 */
	private ConvertEnum(String value, String jmsTemplate) {
		this.value = value;
		this.jmsTemplate = jmsTemplate;
	}

}
