package com.pcloud.common.utils;/**
 * Created by ${user} on ${date}
 */

import com.alibaba.fastjson.JSON;
import com.pcloud.common.entity.UploadResultInfo;
import com.pcloud.common.enums.ImageTypeEnum;
import com.pcloud.common.utils.aliyun.OssUtils;
import com.pcloud.common.utils.httpclient.SimpleHttpUtils;
import com.pcloud.common.utils.json.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

/**
 * @author TianChao
 * @date 2018/10/13 15:02
 */
public class PictureUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(PictureUtil.class);

    private static Color defaultColor = new Color(252, 252, 252);
    private static Color borderColor = new Color(221, 221, 221);

    private static String playPic = "https://file.5rs.me/oss/uploadfe/png/3c687bffac4d885ecfff8517d6c3f9c2.png";
    private static String defaultBackgroundPic = "https://oss.5rs.me/oss/uploadfe/png/3003b8978e85052f96ababdf7d46f70a.png";
    private static String borderPic = "C:\\Users\\LiHao\\Desktop\\封面图\\书本背景.png";

    public static Color getImagePixel(String imgFile)  {
        BufferedImage bi = null;
        try {
            if(imgFile.contains("http")){
                bi = ImageIO.read(new URL(imgFile));
            }else{
                bi = ImageIO.read(new File(imgFile));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        int width = bi.getWidth();
        int height = bi.getHeight();
        int sum=width*height;
        int minx = bi.getMinX();
        int miny = bi.getMinY();
        int R = 0;
        int G = 0;
        int B = 0;
        for (int i = minx; i < width; i++) {
            for (int j = miny; j < height; j++) {
                int pixel = bi.getRGB(i, j);
                R +=(pixel & 0xff0000) >> 16;
                G +=(pixel & 0xff00) >> 8;
                B +=(pixel & 0xff);
            }
        }
        R = R/sum;
        G = G/sum;
        B = B/sum;
        return new Color(R,G,B);
    }

    public static String toBrowserHexValue(int number) {
        StringBuilder builder = new StringBuilder(
                Integer.toHexString(number & 0xff));
        while (builder.length() < 2) {
            builder.append("0");
        }
        return builder.toString().toUpperCase();
    }

    private static BufferedImage  subPicByWhite(BufferedImage picImage){
        return picImage.getSubimage(9, 9, 699, 300);
    }
    public static Color toColorFromString(String colorStr){
        colorStr = colorStr.substring(2);
        Color color =  new Color(Integer.parseInt(colorStr, 16)) ;
        return color;
    }

    private static BufferedImage  subPic(BufferedImage picImage){
        int w=picImage.getWidth();
        int h=picImage.getHeight();
        int x1=w,y1=h,x2=0,y2=0;
        for(int i=0;i<w;i++){
            for(int j=0;j<h;j++){
                int rgb=picImage.getRGB(i, j);
                if(rgb!=0){//不透明
                    if(i<x1) x1=i;
                    if(j<y1) y1=j;
                    if(i>x2) x2=i;
                    if(j>y2) y2=j;
                }
            }
        }

        return picImage.getSubimage(x1, y1, x2-x1+1, y2-y1+1);
    }


    public static String getQrCover(String bookPic,boolean isDefault){
        String resultPath = "";
        try {
            Color color;
            if(bookPic.contains("/oss/")){
                String s = SimpleHttpUtils.httpGet(bookPic + "?x-oss-process=image/average-hue", null);
                System.out.println(s);
                Map map = JSONUtils.jsonToMap(s, String.class, String.class);
                String rgb = (String)map.get("RGB");
                color = toColorFromString(rgb);
            }else{
                color = getImagePixel(bookPic);
            }
            String lightIcon = "https://oss.5rs.me/oss/uploadfe/png/12dcbc38528d926912c444765d786a9a.png";
            String deepIcon = "https://oss.5rs.me/oss/uploadfe/png/60612a7415bdac8533568ae0c21a94b6.png";
            String icon;
            if(color!=null && (color.getRed()<180||color.getBlue()<180||color.getGreen()<180)){
                icon = lightIcon;
            }else{
                icon = deepIcon;
            }
            String html = "<div style = \"position: relative;width: 700px;height: 300px;border: 0px solid green;background-color: #fcfcfc;text-align: center;\"> <div style = \"position: absolute;width: 100%;height: 66%;background-color: rgb("+color.getRed()+","+color.getGreen()+","+color.getBlue()+");overflow: hidden;\"> <div style = \"position: absolute;top: 20px;right: -20px;background-image: url('"+icon+"');background-size: 100%;width: 219px;height: 149px;\"> </div> </div><div style=\"position: relative;display: inline-block;width: 158px;height: 225px;box-shadow: 0px 4px 14px 2px rgba(14, 47, 70, 0.2);border-radius: 4px;border: solid 1px #ddd; margin-top: 35px;background: url('"+bookPic+"') no-repeat;background-size: cover;background-position: center;\"></div></div>";
            Map<String,String>header = new HashMap<>();
            header.put("Content-Type", "application/json");
            Map<String,String>param = new HashMap<>();
            param.put("htmlCode",html);
            String postResult = HttpKit.post("http://192.168.92.111:8214/transcode/htm2img/jpg", JSON.toJSONString(param));
            Map map = JSONUtils.jsonToMap(postResult, String.class, String.class);
            String pic = (String)map.get("data");
            BufferedImage bookPicImage = ImageIO.read(new URL(pic));
            BufferedImage bufferedImage = subPicByWhite(bookPicImage);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write(bufferedImage, ImageTypeEnum.JPG.value, os);
            UploadResultInfo uploadResultInfo = OssUtils.uploadFileByte(os.toByteArray(), UUIDUitl.taskName(), ImageTypeEnum.JPG.value);
            os.close();
            resultPath = uploadResultInfo == null ? null : uploadResultInfo.getUrl();
        } catch (Exception e) {
            LOGGER.error("生成合成图失败,url="+bookPic+"====="+e.getMessage(),e);
        }
        return resultPath;

    }


    public static void main(String[] args) {
   //     String bookPic = "https://file.5rs.me/oss/upload/image/jpg/c2c7f0b85f9f4eb683cd86a2945bc5e5.jpg";
        String s = "";
        String bookPic = "C:\\Users\\LiHao\\Desktop\\封面图\\yy.png";
        String playPic = "C:\\Users\\LiHao\\Desktop\\封面图\\播放按钮.png";
        String defaultBackgroundPic = "C:\\Users\\LiHao\\Desktop\\封面图\\默认图背景.png";
        String resultPath = "C:\\Users\\LiHao\\Desktop\\封面图\\result.jpg";

        String oath = "C:\\Users\\LiHao\\Desktop\\封面图\\书本背景.png";

        Boolean isDefalut = false;
        try {
            //取书封面和播放按钮图
            BufferedImage bookPicImage;
            BufferedImage playPicImage;
            BufferedImage defaultBackgroudImage;
            BufferedImage oathI;
            if(bookPic.contains("https:")){
                 bookPicImage = ImageIO.read(new URL(bookPic));
                 playPicImage = ImageIO.read(new URL(playPic));
                 defaultBackgroudImage = ImageIO.read(new URL(defaultBackgroundPic));
                 oathI = ImageIO.read(new URL(oath));
            }else{
                 bookPicImage = ImageIO.read(new File(bookPic));
                 playPicImage = ImageIO.read(new File(playPic));
                 defaultBackgroudImage = ImageIO.read(new File(defaultBackgroundPic));
                 oathI = ImageIO.read(new File(oath));
            }

            //画一个空的背景
            BufferedImage bg = new BufferedImage(702, 299, BufferedImage.TYPE_3BYTE_BGR);
            Graphics2D g = bg.createGraphics();
            //获取主题色
            Color c = getImagePixel(bookPic);
            bookPicImage = subPic(bookPicImage);
            //画纯色的背景或者默认背景图
            g.setColor(c);
            if(isDefalut){
                g.drawImage(defaultBackgroudImage.getScaledInstance(702,196, Image.SCALE_DEFAULT), 0, 0, null);
            }else {
                g.fillRect(0, 0, 702, 196);
            }
            g.setColor(new Color(252, 252, 252));
            g.fillRect(0, 196, 702, 102);

            g.setColor(new Color(221, 221, 221));
            //插入书籍图和播放按钮


          //  g.drawImage(oathI.getScaledInstance(185,252, Image.SCALE_DEFAULT), 258, 33, null);

            g.drawImage(bookPicImage.getScaledInstance(157,224, Image.SCALE_DEFAULT), 265, 30, null);
            g.drawImage(playPicImage.getScaledInstance(80,80, Image.SCALE_DEFAULT), 306, 105, null);
            g.drawRect(265,30,172,238);


            //保存图片
            if(bookPic.contains("https:")) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write(bg, ImageTypeEnum.JPG.value, os);
                UploadResultInfo uploadResultInfo = OssUtils.uploadFileByte(os.toByteArray(), UUIDUitl.taskName(), ImageTypeEnum.JPG.value);
                os.close();
                s = uploadResultInfo == null ? null : uploadResultInfo.getUrl();
            }else{
                OutputStream os = new FileOutputStream(resultPath);
                ImageIO.write(bg, ImageTypeEnum.JPG.value, os);
                os.close();
            }
            System.out.println(s);
        } catch (Exception e) {
            System.out.println(e.getMessage());
        }

    }




}
