package com.pcloud.book.book.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@ApiModel("ERP图书信息")
public class ErpBookInfoDTO {

    @ApiModelProperty("项目编号")
    private String projectNumber;

    @ApiModelProperty("erp编号")
    private String erpNumber;

    @ApiModelProperty("出版物名称")
    private String bookName;

    @ApiModelProperty("RAYS编辑ID")
    private Integer raysAdviserId;

    @ApiModelProperty("关联RAYS书刊ID")
    private Integer raysBookId;

    @ApiModelProperty("关联RAYS渠道ID")
    private Integer raysChannelId;

    @ApiModelProperty("编辑id")
    private Long adviserId;

    @ApiModelProperty("ISBN")
    private String isbn;

    @ApiModelProperty("印册量")
    private Long publishNum;

    @ApiModelProperty("立项时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date buildTime;

}
