package com.pcloud.book.push.service;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.Map;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @描述：个人号群发
 * @作者：zhuyajie
 * @创建时间：10:44 2019/12/10
 * @版本：1.0
 */
@FeignClient(value = "pcloud-service-book", qualifiers = "selfPushServiceCloud", path = "book/v1.0/selfPushService")
@Api(description = "个人号群发消息内部服务")
public interface SelfPushService {

    @ApiOperation(value = "定时器调用个人号群发接口", httpMethod = "POST")
    @RequestMapping(value = "/sendSelfMsgQuartz", method = RequestMethod.POST)
    public void sendSelfMsgQuartz(@RequestBody Map<String, Object> map);

}
