package com.pcloud.book.applet.dao;

import com.pcloud.book.applet.dto.CollectionTypeNameAndCountDTO;
import com.pcloud.book.applet.dto.ServeCollectDTO;
import com.pcloud.book.applet.entity.ServeCollect;
import com.pcloud.book.applet.vo.CollectionTypeNameCodeClassifyVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * (ServeCollect)表数据库访问层
 *
 * @author makejava
 * @since 2020-09-10 10:44:31
 */
public interface ServeCollectDao extends BaseDao<ServeCollect> {

    void cancelCollect(List<Long> ids);

    void deleteInvalidNews(List<Long> newsIds);

    List<ServeCollect> getList4RightsSetting(List<ServeCollect> serveCollects);

    List<Long> getAllCollect(List<Long> wechatUserIds,String typeCode);

    List<ServeCollectDTO> getList4Collect(List<ServeCollectDTO> serveCollects);

    List<ServeCollect> getList4RightsSettingByWechatUserId(Long wechatUserId);

    List<CollectionTypeNameAndCountDTO> getTypeNameAndCountByWechatId(List<Long> wechatUserIds );

    ServeCollectDTO isCollected(Long wechatUserId, Long serveId, Integer serveType);

    List<CollectionTypeNameCodeClassifyVO> getDistinctTypeCode();

    void updateTypeName(Map<String,String> paramMap);

    List<ServeCollect> List2ProcessedData();

    void batchUpdate(List<ServeCollect> serveCollectList);

    ServeCollect getCollectByUser(List<Long> wechatUserId, Long serveId, Integer serveType);

    List<ServeCollect> getCollectList(List<Long> allUnionUserIds, Long serveId, Integer serveType, Integer isDelete);
}