package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletBannerDao;
import com.pcloud.book.applet.dto.AppletBannerTrendDTO;
import com.pcloud.book.applet.entity.AppletBanner;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class AppletBannerDaoImpl extends BaseDaoImpl<AppletBanner> implements AppletBannerDao {

    @Override
    public Integer getMaxSeq(Long agentId) {
        Map<String, Object>map = new HashMap<>();
        map.put("agentId", agentId);
        return getSessionTemplate().selectOne(getStatement("getMaxSeq"), map);
    }

    @Override
    public List<AppletBannerTrendDTO> getBannerRecordTrendByHour(String createDate) {
        return getSessionTemplate().selectList(getStatement("getBannerRecordTrendByHour"), createDate);
    }

    @Override
    public List<AppletBannerTrendDTO> getSendMessageTrendByDay(String startDate, String endDate) {
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put("startDate",startDate);
        paramMap.put("endDate",endDate);
        return getSessionTemplate().selectList(getStatement("getSendMessageTrendByDay"), paramMap);
    }

    @Override
    public void updateShowState(AppletBanner appletBanner) {
        getSessionTemplate().update(getStatement("updateShowState"), appletBanner);
    }
}
