package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletNewsClassifyDao;
import com.pcloud.book.applet.dto.AppletNewsClassifyDTO;
import com.pcloud.book.applet.entity.AppletNewsClassify;
import com.pcloud.book.applet.entity.AppletNewsClassifyUser;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class AppletNewsClassifyDaoImpl extends BaseDaoImpl<AppletNewsClassify> implements AppletNewsClassifyDao {
    @Override
    public Integer getMaxSeq(Long agentId) {
        Map<String,Object> map=new HashMap<>();
        map.put("agentId", agentId);
        return getSessionTemplate().selectOne(getStatement("getMaxSeq"), map);
    }

    @Override
    public List<AppletNewsClassifyDTO> getAllNewsClassify(Boolean showState, Long agentId) {
        Map<String,Object> map=new HashMap<>();
        map.put("showState", showState);
        map.put("agentId", agentId);
        return getSessionTemplate().selectList(getStatement("getAllNewsClassify"), map);
    }

    @Override
    public void batchInsertUserNewsClassify(List<AppletNewsClassifyUser> appletNewsClassifyUsers) {
        getSessionTemplate().insert(getStatement("batchInsertUserNewsClassify"), appletNewsClassifyUsers);
    }

    @Override
    public void deleteClassifyByWechatUesrId(Long wechatUserId) {
        getSessionTemplate().delete(getStatement("deleteClassifyByWechatUesrId"), wechatUserId);
    }

    @Override
    public List<Long> getClassifyIdsByUserId(Long wechatUserId) {
        return getSessionTemplate().selectList(getStatement("getClassifyIdsByUserId"),wechatUserId);
    }

    @Override
    public List<AppletNewsClassifyDTO> getClassifysByUserId(Long wechatUserId) {
        return getSessionTemplate().selectList(getStatement("getClassifysByUserId"), wechatUserId);
    }
}
