package com.pcloud.book.consumer.function;

import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.function.douluo.dto.AppTaskDTO;
import com.pcloud.function.douluo.service.DlAppTaskService;
import com.pcloud.function.douluo.service.DlBookService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
@Component
public class FunctionConsr {

    @Autowired
    private DlBookService dlBookService;
    @Autowired
    private DlAppTaskService dlAppTaskService;

    /**
     根据bookId判断是否斗罗书
     */
    public Boolean checkIsDlBook(Long bookId){
        Boolean isDlBook = false;
        if (null == bookId) {
            return isDlBook;
        }
        try {
            isDlBook = ResponseHandleUtil.parseResponse(dlBookService.checkIsDlBook(bookId), Boolean.class);
        } catch (Exception e) {
            log.error("function.dlBookService.checkIsDlBook远程调用失败");
        }
        return isDlBook;
    }

    public List<AppTaskDTO> getAppTaskList() {
        List<AppTaskDTO> appTaskList = new ArrayList<>();
        try {
            appTaskList = ResponseHandleUtil.parseListResponse(dlAppTaskService.getAppTaskList(), AppTaskDTO.class);
        } catch (Exception e) {
            log.error("function.dlAppTaskService.getAppTaskList()远程调用失败");
        }
        return appTaskList;
    }
}

