package com.pcloud.book.consumer.wordapp;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.wordapp.word.service.MiniWordService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * @ClassName com.pcloud.book.consumer.wodapp.WordappConsr
 * @Author zhuyajie
 * @Description 背单词
 * @Date 2021/3/4 17:28
 * @Version 1.0
 **/
@Slf4j
@Component
public class WordappConsr {

    @Autowired
    private MiniWordService miniWordService;

    @ParamLog("是否配置了背单词小程序")
    public Boolean hasMiniWord(Long bookId) {
        Boolean has = false;
        try {
            has = ResponseHandleUtil.parseResponse(miniWordService.hasMiniWord(bookId), Boolean.class);

        } catch (Exception e) {
            log.error("调用miniWordService.hasMiniWord失败" + e.getMessage(), e);
        }
        return has;
    }
}
