package com.pcloud.book.keywords.entity;

import com.pcloud.common.entity.BaseEntity;
import com.pcloud.contentcenter.resource.dto.ResourceOfficeItemDTO;
import com.pcloud.contentcenter.resource.dto.ResourcePdfItemDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Description
 * @Author zhuyajie
 * @Date 2020/02/03 11:39
 **/
@Data
@ApiModel("个人号关键词回复")
public class SelfRobotKeywordReply extends BaseEntity {

    @ApiModelProperty("关键词id")
    private Long keywordId;

    @ApiModelProperty("类型 1 文字 2 图片 3 链接 4应用 5素材")
    private Integer type;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("描述")
    private String description;

    @ApiModelProperty("链接地址")
    private String linkUrl;

    @ApiModelProperty("图片地址")
    private String picUrl;

    @ApiModelProperty("应用或作品id")
    private Long serveId;

    @ApiModelProperty("应用或作品类型")
    private String serveType;

    @ApiModelProperty("资源id")
    private Long resourceId;

    @ApiModelProperty("排序值")
    private Integer seqNum;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("应用或作品图片")
    private String servePic;

    @ApiModelProperty("应用或作品名称")
    private String serveName;

    @ApiModelProperty("应用或作品类型名称")
    private String serveTypeName;

    @ApiModelProperty("应用或作品类型编码")
    private String serveTypeCode;

    @ApiModelProperty("资源链接")
    private String resourceUrl;

    @ApiModelProperty("资源名称")
    private String resourceName;

    @ApiModelProperty("资源类型编码")
    private String resourceTypeCode;

    @ApiModelProperty("资源类型名称")
    private String resourceTypeName;

    @ApiModelProperty("文件类型")
    private String fileType;

    @ApiModelProperty("pdf转码后的单张图片集合")
    private List<ResourcePdfItemDTO> resourcePdfItems;

    @ApiModelProperty("文件转码后的单张图片集合")
    private List<ResourceOfficeItemDTO> resourceOfficeItemDTOs;
}
