/**
 * 
 */
package com.pcloud.book.util.properties;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @描述：微信常量类
 * @作者：songx
 * @创建时间：2016年11月23日,上午10:12:37 @版本：1.0
 */
@Component("bookProps")
public class BookProps {

	/**
	 * ISBN
	 */
	private static String appkey;

	/**
	 * 图书封面图
	 */
	private static String bookCoverImg;

	/**
	 * ISBN
	 */
	private static String appCode;

	/**
	 * ISBNjisuAppKey
	 */
	private static String jisuAppKey;

	private static String systemEnv;

	private static String wechatDomain;

	/**
	 * 小程序公众号id 777
	 */
	private static Long miniOfficialAccountsId;

	private static Long operateOfficalId;

	//默认公众号id
	private static Long defaultChannelId;


	public static Long getDefaultChannelId() {
		return defaultChannelId;
	}

	@Value("${default.channel.id}")
	public   void setDefaultChannelId(Long defaultChannelId) {
		BookProps.defaultChannelId = defaultChannelId;
	}

	public static Long getOperateOfficalId() {
		return operateOfficalId;
	}

	@Value("${operate_official_id}")
	public void setOperateOfficalId(Long operateOfficalId) {
		BookProps.operateOfficalId = operateOfficalId;
	}

	public static String getJisuAppKey() {
		return jisuAppKey;
	}

	@Value("${isbn.jisu.appkey}")
	public void setJisuAppKey(String jisuAppKey) {
		BookProps.jisuAppKey = jisuAppKey;
	}

	public static String getAppkey() {
		return appkey;
	}

	public static String getBookCoverImg() {
		return bookCoverImg;
	}

	public static String getAppCode() {
		return appCode;
	}

	@Value("${isbn.appkey}")
	public void setAppkey(String appkey) {
		BookProps.appkey = appkey;
	}

	@Value("${book.cover.img}")
	public void setBookCoverImg(String bookCoverImg) {
		BookProps.bookCoverImg = bookCoverImg;
	}

	@Value("${isbn.appCode}")
	public void setAppCode(String appCode) {
		BookProps.appCode = appCode;
	}


	public static String getSystemEnv() {
		return systemEnv;
	}

	@Value("${system.env}")
	public void setSystemEnv(String systemEnv) {
		BookProps.systemEnv = systemEnv;
	}

	public static String getWechatDomain() {
		return wechatDomain;
	}

	@Value("${wechat.group.link.prefix}")
	public void setWechatDomain( String wechatDomain ) {
		BookProps.wechatDomain = wechatDomain;
	}

	@Value("${manage_official_id}")
	private Long manageOfficialId;

	public Long getManageOfficialId() {
		return manageOfficialId;
	}

	public void setManageOfficialId(Long manageOfficialId) {
		this.manageOfficialId = manageOfficialId;
	}
	@Value("${our_manager_account_id}")
	private Long ourManagerAccountId;

	public Long getOurManagerAccountId() {
		return ourManagerAccountId;
	}

	public void setOurManagerAccountId(Long ourManagerAccountId) {
		this.ourManagerAccountId = ourManagerAccountId;
	}

	private static  Long healsAdviserId;

	public static Long getHealsAdviserId() {
		return healsAdviserId;
	}
	@Value("${heals.adviserId}")
	public void setHealsAdviserId(Long healsAdviserId) {
		BookProps.healsAdviserId = healsAdviserId;
	}

	public static Long getMiniOfficialAccountsId() {
		return miniOfficialAccountsId;
	}

	@Value("${mini.official.account.id}")
	public void setMiniOfficialAccountsId(Long miniOfficialAccountsId) {
		BookProps.miniOfficialAccountsId = miniOfficialAccountsId;
	}


	private static String productDomain;

	public static String getProductDomain() {
		return productDomain;
	}

	@Value("${PRODUCT_DOMAIN}")
	public   void setProductDomain(String productDomain) {
		BookProps.productDomain = productDomain;
	}
}
