package com.pcloud.book.group.dto;

import java.util.List;

import lombok.Data;

/**
 * @描述：个人号读者信息查询参数
 * @作者：zhuyajie
 * @创建时间：11:05 2019/11/11
 * @版本：1.0
 */
@Data
public class SelfRobtParamDTO {

    /**
     * 读者id列表
     */
    private List<String> userIds;
    /**
     * 个人号id列表
     */
    private List<String> robotIds;
    /**
     * 图书id列表
     */
    private List<Long> bookIds;
    /**
     * 当前页
     */
    private Integer currentPage;
    /**
     * 每页数量
     */
    private Integer numPerPage;

    /**
     * 个人号用户筛选，用户筛选好友状态
     */
    List<SelfRobotUserDTO> deleteUserDTOS;

    /**
     * 好友状态 1：已同意 2：已删除
     */
    private Integer friendState;

}
