package com.pcloud.book.clock.check;

import com.pcloud.book.clock.dto.BookClockInfoDTO;
import com.pcloud.book.clock.entity.BookClockInfo;
import com.pcloud.book.clock.entity.BookClockKeyword;
import com.pcloud.book.group.dto.GroupClassifyQrcodeDTO;

import java.util.List;

/**
 * @Author: hzk
 * @Date: 2019/5/27 9:26
 * @Version 1.0
 */
public interface BookClockCheck {

    void checkParam4CreateBookGroupClock(BookClockInfo bookClockInfo);

    /**
     * 校验作品及应用
     * @param bookClockInfo
     * @return
     */
    BookClockInfo checkOriginIdAndOriginType(BookClockInfo bookClockInfo);

    /**
     * 校验关键词
     * @param bookClockKeywordList
     */
    void checkBookClockKeyword(List<BookClockKeyword> bookClockKeywordList,Long adviserId,List<Long> bookGroupIdList,List<Long> classifyIdList);

    /**
     * 校验关键词是否为打卡关键词
     * @param content
     * @param weixinGroupId
     * @return
     */
    BookClockInfoDTO checkKeywordIsClock(String content, String weixinGroupId);

    /**
     * 校验群是否为微信群打卡的群
     * @param classifyQrcodeInfo
     * @return
     */
    List<Long> checkGroupIsClock(GroupClassifyQrcodeDTO classifyQrcodeInfo);

}
