/**
 * 
 */
package com.pcloud.book.consumer.user;

import com.pcloud.channelcenter.base.exceptions.ChannelBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.usercenter.party.agent.entity.Agent;
import com.pcloud.usercenter.party.agent.service.AgentService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @描述：代理工具类
 * @作者：songx
 * @创建时间：2016年11月18日,上午10:35:13 @版本：1.0
 */
@Component("agentConsr")
public class AgentConsr {

	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(AgentConsr.class);

	@Autowired
	private AgentService agentService;

	/**
	 * 获取代理类型
	 */
	public Integer getAgentType(Long partyId, String systemCode) throws BizException {
		LOGGER.info("【代理用户(消)】获取代理类型,<START>.[partyId]=" + partyId);
		Integer agentType = null;
		try {
			agentType = ResponseHandleUtil.parseResponse(agentService.getAgentType(partyId, systemCode), Integer.class);
		} catch (Exception e) {
			LOGGER.error("【代理用户(消)】获取代理类型,<ERROR>.[getAgentType]:" + e.getMessage(), e);
		}
		return agentType == null ? null : agentType;
	}

	/**
	 * 获取出版对应运营信息
	 */
	public Long getDefaultChannel(Long agentId) throws BizException {
		LOGGER.info("【出版用户(消)】获取出版默认运营信息,<START>.[agentId]=" + agentId);
		try {
			return ResponseHandleUtil.parseResponse(agentService.getDefaultChannel(agentId), Long.class);
		} catch (Exception e) {
			LOGGER.error("【出版用户(消)】获取出版默认运营信息.[getDefaultChannel]:" + e.getMessage(), e);
			throw new ChannelBizException(ChannelBizException.PARAM_IS_NULL, "运营不存在");
		}
	}

	public Long getAgentIdByType(Integer agentType){
		LOGGER.info("根据出版端心获取出版信息【start】，参数：agentType="+agentType);
		if(agentType==null){
			return null;
		}
		ResponseEntity<ResponseDto<Agent>> agentInfoByType = agentService.getAgentInfoByType(agentType);
		Agent agent = ResponseHandleUtil.parseResponse(agentInfoByType, Agent.class);
		LOGGER.info("根据出版端心获取出版信息【end】，返回值agent="+agent);
		if(agent==null){
			return null;
		}
		return agent.getId();
	}

    /**
     * 批量获取出版名称
     */
    public Map<Long, String> getNames(List<Long> agentIds) throws BizException {
        LOGGER.info("【出版用户(消)】批量获取出版名称,<START>.[agentIds]=" + agentIds.toString());
        if (ListUtils.isEmpty(agentIds)) {
            return null;
        }
        Map<Long, String> agentMap = null;
        try {
            agentMap = ResponseHandleUtil.parseMapResponse(agentService.getNamesByIdList(agentIds), Long.class,
                    String.class);
        } catch (Exception e) {
            LOGGER.error("【出版用户(消)】批量获取出版名称.[getNames]:" + e.getMessage(), e);
        }
        return agentMap;
    }
}
