package com.pcloud.book.es.facade;

import com.pcloud.book.push.entity.News;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "pcloud-service-book", qualifier = "esNewsFacadeCloud", path = "esNews")
@Api(description = "ES外部接口")
public interface ESNewsFacade {

    @ApiOperation("添加所有的新闻到es")
    @PostMapping("addAllNewsToES")
    ResponseDto<?> addAllNewsToES() throws BizException;

    @ApiOperation("新增新闻")
    @PostMapping("addNews")
    ResponseDto<?> addNews(@RequestBody News news) throws BizException;

}
