package com.pcloud.book.group.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

/**
 * @author lily
 * @date 2019/4/17 16:30
 */
public class GroupQrcode  extends BaseEntity {

    /**
     * 分类二维码标识
     */
    private Long id;

    /**
     * 群分类标识
     */
    private Long classifyId;

    /**
     * 群名称
     */
    private String groupName;

    /**
     * 群序号
     */
    private Integer groupSeq;

    /**
     * 群人数
     */
    private Integer userNumber;

    /**
     * 微信二维码标识
     */
    private Long weixinQrcodeId;

    /**
     * 微信群标识（微信所在群独有标识）
     */
    private String weixinGroupId;

    /**
     * 群二维码图片地址
     */
    private String qrcodeUrl;

    /**
     * 使用状态
     */
    private Integer useState;

    /**
     * 群二维码状态
     */
    private Integer qrcodeState;

    /**
     * 修改名称状态
     */
    private Integer changeNameState;

    /**
     * 删除状态
     */
    private Integer isDelete;

    /**
     * 创建人
     */
    private Long createUser;

    /**
     * 修改用户
     */
    private Long updateUser;
    /**
     * 猜谜语是否开启
     */
    private Boolean riddleOpen;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    private String qrcodeHeadUrl;

    public String getQrcodeHeadUrl() {
        return qrcodeHeadUrl;
    }

    public void setQrcodeHeadUrl(String qrcodeHeadUrl) {
        this.qrcodeHeadUrl = qrcodeHeadUrl;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Integer getGroupSeq() {
        return groupSeq;
    }

    public void setGroupSeq(Integer groupSeq) {
        this.groupSeq = groupSeq;
    }

    public Integer getUserNumber() {
        return userNumber;
    }

    public void setUserNumber(Integer userNumber) {
        this.userNumber = userNumber;
    }

    public Long getWeixinQrcodeId() {
        return weixinQrcodeId;
    }

    public void setWeixinQrcodeId(Long weixinQrcodeId) {
        this.weixinQrcodeId = weixinQrcodeId;
    }

    public String getWeixinGroupId() {
        return weixinGroupId;
    }

    public void setWeixinGroupId(String weixinGroupId) {
        this.weixinGroupId = weixinGroupId;
    }

    public String getQrcodeUrl() {
        return qrcodeUrl;
    }

    public void setQrcodeUrl(String qrcodeUrl) {
        this.qrcodeUrl = qrcodeUrl;
    }

    public Integer getUseState() {
        return useState;
    }

    public void setUseState(Integer useState) {
        this.useState = useState;
    }

    public Integer getChangeNameState() {
        return changeNameState;
    }

    public void setChangeNameState(Integer changeNameState) {
        this.changeNameState = changeNameState;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getQrcodeState() {
        return qrcodeState;
    }

    public void setQrcodeState(Integer qrcodeState) {
        this.qrcodeState = qrcodeState;
    }

    public Boolean getRiddleOpen() {
        return riddleOpen;
    }

    public void setRiddleOpen(Boolean riddleOpen) {
        this.riddleOpen = riddleOpen;
    }

    @Override
    public String toString() {
        return "GroupQrcode{" +
                "id=" + id +
                ", classifyId=" + classifyId +
                ", groupName='" + groupName + '\'' +
                ", groupSeq=" + groupSeq +
                ", userNumber=" + userNumber +
                ", weixinQrcodeId=" + weixinQrcodeId +
                ", weixinGroupId='" + weixinGroupId + '\'' +
                ", qrcodeUrl='" + qrcodeUrl + '\'' +
                ", useState=" + useState +
                ", qrcodeState=" + qrcodeState +
                ", changeNameState=" + changeNameState +
                ", isDelete=" + isDelete +
                ", createUser=" + createUser +
                ", updateUser=" + updateUser +
                ", riddleOpen=" + riddleOpen +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", qrcodeHeadUrl='" + qrcodeHeadUrl + '\'' +
                '}';
    }
}
