package com.pcloud.book.group.facade.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.group.biz.CopyCipherRecordBiz;
import com.pcloud.book.group.entity.CopyCipherRecord;
import com.pcloud.book.group.facade.CopyCipherRecordFacade;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/11/15 14:16
 **/
@RestController("copyCipherRecordFacade")
@RequestMapping("copyCipherRecord")
public class CopyCipherRecordFacadeImpl implements CopyCipherRecordFacade {

    @Autowired
    private CopyCipherRecordBiz copyCipherRecordBiz;

    @ApiOperation("新增点击复制暗号记录")
    @PostMapping("createCopyCipherRecord")
    @Override
    public ResponseDto<?> createCopyCipherRecord(
            @CookieValue("userInfo") String userInfo,
            @RequestBody @ApiParam("点击复制暗号记录模型") CopyCipherRecord copyCipherRecord
    ) throws BizException {
        if (copyCipherRecord==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"参数为空！");
        }
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        copyCipherRecord.setWechatUserId(wechatUserId);
        return new ResponseDto<>(copyCipherRecordBiz.createCopyCipherRecord(copyCipherRecord));
    }
}
