package com.pcloud.book.guide.biz.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.guide.biz.PcloudGuideBiz;
import com.pcloud.book.guide.entity.PcloudGuide;
import com.pcloud.book.guide.entity.PcloudGuideMessage;
import com.pcloud.book.guide.mapper.PcloudGuideMapper;
import com.pcloud.book.guide.mapper.PcloudGuideMessageMapper;
import com.pcloud.book.guide.mapper.PcloudRobotSilenceMapper;
import com.pcloud.book.guide.vo.*;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.utils.BeanUtils;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

@Component("pcloudGuideBiz")
public class PcloudGuideBizImpl implements PcloudGuideBiz {

    @Autowired
    private PcloudGuideMapper pcloudGuideMapper;

    @Autowired
    private PcloudGuideMessageMapper pcloudGuideMessageMapper;

    @Autowired
    private PcloudRobotSilenceMapper pcloudRobotSilenceMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Integer addPcloudGuide(CreatePcloudGuideVO createPcloudGuideVO) {
        //参数校验
        List<PcloudGuideMessageVO> messageVOList = createPcloudGuideVO.getMessageVOList();
        if (ListUtils.isEmpty(messageVOList)) {
            throw new BookBizException(BookBizException.ERROR, "请添加回复内容");
        }
        if (messageVOList.size() > 3) {
            throw new BookBizException(BookBizException.ERROR, "最多添加3条回复内容");
        }

        Integer maxSeqNum = pcloudGuideMapper.getMaxSeqNum(null);
        PcloudGuide pcloudGuide = new PcloudGuide();
        pcloudGuide.setType(0);
        pcloudGuide.setRobotWxId(null);
        pcloudGuide.setSeqNum(maxSeqNum + 1);
        pcloudGuide.setTimeSpan(0);
        pcloudGuideMapper.insert(pcloudGuide);
        Integer id = pcloudGuide.getId();
        List<PcloudGuideMessage> list = new ArrayList<>();
        messageVOList.forEach(item -> {
            PcloudGuideMessage pcloudGuideMessage = new PcloudGuideMessage();
            BeanUtils.copyProperties(item, pcloudGuideMessage);
            pcloudGuideMessage.setPcloudGuideId(id);
            list.add(pcloudGuideMessage);
        });
        pcloudGuideMessageMapper.batchInsert(list);
        return id;
    }

    @Override
    public void deletePcloudGuide(Integer pcloudGuideId) {
        pcloudGuideMapper.deleteByPrimaryKey(pcloudGuideId);

        pcloudGuideMessageMapper.deleteByGuideId(pcloudGuideId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updatePcloudGuide(UpdatePcloudGuideVO updatePcloudGuideVO) {
        PcloudGuide pcloudGuide = pcloudGuideMapper.selectByPrimaryKey(updatePcloudGuideVO.getPcloudGuideId());
        if (null == pcloudGuide) {
            return;
        }
        List<PcloudGuideMessageVO> messageVOList = updatePcloudGuideVO.getMessageVOList();
        if (ListUtils.isEmpty(messageVOList)) {
            throw new BookBizException(BookBizException.ERROR, "请添加回复内容");
        }
        if (messageVOList.size() > 3) {
            throw new BookBizException(BookBizException.ERROR, "最多添加3条回复内容");
        }
        pcloudGuide.setTimeSpan(updatePcloudGuideVO.getTimeSpan());
        pcloudGuideMapper.updateByPrimaryKey(pcloudGuide);

        Integer id = pcloudGuide.getId();
        List<PcloudGuideMessage> list = new ArrayList<>();
        messageVOList.forEach(item -> {
            PcloudGuideMessage pcloudGuideMessage = new PcloudGuideMessage();
            BeanUtils.copyProperties(item, pcloudGuideMessage);
            pcloudGuideMessage.setPcloudGuideId(id);
            list.add(pcloudGuideMessage);
        });
        pcloudGuideMessageMapper.deleteByGuideId(id);
        pcloudGuideMessageMapper.batchInsert(list);
    }

    @Override
    public PcloudGuideVO getPcloudGuide(Integer pcloudGuideId) {
        PcloudGuideVO pcloudGuideVO = new PcloudGuideVO();
        PcloudGuide pcloudGuide = pcloudGuideMapper.selectByPrimaryKey(pcloudGuideId);
        if (null != pcloudGuide) {
            pcloudGuideVO.setPcloudGuideId(pcloudGuideId);
            pcloudGuideVO.setSeqNum(pcloudGuide.getSeqNum());
            pcloudGuideVO.setTimeSpan(pcloudGuide.getTimeSpan());
            List<PcloudGuideMessageVO> list = pcloudGuideMessageMapper.listByGuideId(pcloudGuideId);
            pcloudGuideVO.setMessageVOList(list);
        }
        return pcloudGuideVO;
    }

    @Override
    public PageBeanNew<PcloudGuideVO> listPcloudGuide(Integer currentPage, Integer numPerPage, String robotWxId, String search) {
        Integer count = pcloudGuideMapper.getCount(robotWxId, search);
        List<PcloudGuideVO> list = new ArrayList<>();
        if (count <= 0) {
            return new PageBeanNew<>(currentPage, numPerPage, list);
        }
        list = pcloudGuideMapper.listPcloudGuide(currentPage * numPerPage, numPerPage, robotWxId, search);
        list.forEach(item -> {
            item.setMessageVOList(pcloudGuideMessageMapper.listByGuideId(item.getPcloudGuideId()));
        });
        return new PageBeanNew<>(currentPage, numPerPage, count, list);
    }

    @Override
    public void updateSeqNum(UpdateSeqNumVO updateSeqNumVO) {
        pcloudGuideMapper.updateSeqNum(updateSeqNumVO.getPcloudGuideId(), updateSeqNumVO.getSeqNum());
    }

    @Override
    public void create4Robot(Create4RobotVO create4RobotVO) {
        List<Integer> pcloudGuideIds = create4RobotVO.getPcloudGuideIds();
        for (Integer pcloudGuideId : pcloudGuideIds) {
            PcloudGuide pcloudGuide = pcloudGuideMapper.selectByPrimaryKey(pcloudGuideId);
            if (null == pcloudGuide) {
               continue;
            }
            String robotWxId = create4RobotVO.getRobotWxId();
            Integer maxSeqNum = pcloudGuideMapper.getMaxSeqNum(robotWxId);
            pcloudGuide.setType(1);
            pcloudGuide.setRobotWxId(robotWxId);
            pcloudGuide.setSeqNum(maxSeqNum +1);
            pcloudGuideMapper.insert(pcloudGuide);
            List<PcloudGuideMessageVO> messageVOList = pcloudGuideMessageMapper.listByGuideId(pcloudGuideId);
            List<PcloudGuideMessage> list = new ArrayList<>();
            messageVOList.forEach(item -> {
                PcloudGuideMessage pcloudGuideMessage = new PcloudGuideMessage();
                BeanUtils.copyProperties(item, pcloudGuideMessage);
                pcloudGuideMessage.setPcloudGuideId(pcloudGuide.getId());
                list.add(pcloudGuideMessage);
            });
            pcloudGuideMessageMapper.batchInsert(list);
        }
    }

    @Override
    public void setSilenceDuration(RobotSilenceVO robotSilenceVO) {
        if (StringUtil.isEmpty(robotSilenceVO.getRobotWxId())) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数错误！");
        }
        pcloudRobotSilenceMapper.setSilenceDuration(robotSilenceVO.getRobotWxId(), robotSilenceVO.getSilenceDuration());
    }
}
