package com.pcloud.book.guide.facade.impl;


import com.pcloud.book.guide.biz.PcloudGuideBiz;
import com.pcloud.book.guide.vo.Create4RobotVO;
import com.pcloud.book.guide.vo.CreatePcloudGuideVO;
import com.pcloud.book.guide.vo.PcloudGuideVO;
import com.pcloud.book.guide.vo.UpdatePcloudGuideVO;
import com.pcloud.book.guide.vo.UpdateSeqNumVO;
import com.pcloud.book.guide.vo.RobotSilenceVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController("pcloudGuideFacade")
@RequestMapping("pcloudGuide")
public class PcloudGuideFacadeImpl {

    @Autowired
    private PcloudGuideBiz pcloudGuideBiz;

    @ApiOperation(value = "新增全平台引导语")
    @PostMapping("addPcloudGuide")
    ResponseDto<?> addPcloudGuide(@RequestHeader String token, @RequestBody CreatePcloudGuideVO createPcloudGuideVO) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        Integer pcloudGuideId = pcloudGuideBiz.addPcloudGuide(createPcloudGuideVO);
        return new ResponseDto<>(pcloudGuideId);
    }

    @ApiOperation(value = "删除引导语")
    @GetMapping("deletePcloudGuide")
    ResponseDto<?> deletePcloudGuide(@RequestHeader String token, @RequestParam Integer pcloudGuideId) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        pcloudGuideBiz.deletePcloudGuide(pcloudGuideId);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "修改引导语")
    @PostMapping("updatePcloudGuide")
    ResponseDto<?> updatePcloudGuide(@RequestHeader String token, @RequestBody UpdatePcloudGuideVO updatePcloudGuideVO) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        pcloudGuideBiz.updatePcloudGuide(updatePcloudGuideVO);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "获取引导语信息")
    @GetMapping("getPcloudGuide")
    ResponseDto<?> getPcloudGuide(@RequestParam Integer pcloudGuideId) {
        return new ResponseDto<>(pcloudGuideBiz.getPcloudGuide(pcloudGuideId));
    }

    @ApiOperation(value = "获取引导语列表")
    @GetMapping("listPcloudGuide")
    ResponseDto<?> listPcloudGuide(@RequestHeader String token, @RequestParam Integer currentPage, @RequestParam Integer numPerPage,
                                   @RequestParam(value = "robotWxId", required = false) String robotWxId, @RequestParam(value = "search", required = false) String search) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        PageBeanNew<PcloudGuideVO> page = pcloudGuideBiz.listPcloudGuide(currentPage, numPerPage, robotWxId, search);
        return new ResponseDto<>(page);
    }

    @ApiOperation(value = "修改排序值")
    @PostMapping("updateSeqNum")
    ResponseDto<?> updateSeqNum(@RequestHeader String token, @RequestBody @Validated UpdateSeqNumVO updateSeqNumVO) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        pcloudGuideBiz.updateSeqNum(updateSeqNumVO);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "新增个人号引导语")
    @PostMapping("add4Robot")
    ResponseDto<?> add4Robot(@RequestHeader String token, @RequestBody Create4RobotVO create4RobotVO) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        pcloudGuideBiz.create4Robot(create4RobotVO);
        return new ResponseDto<>();
    }

    @ApiOperation("机器人小号设置缄默时长")
    @PostMapping("/setSilenceDuration")
    ResponseDto<?> setSilenceDuration(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("机器人小号缄默信息") RobotSilenceVO robotSilenceVO
    )throws BizException, PermissionException{
        SessionUtil.getInfoToken4Redis(token);
        pcloudGuideBiz.setSilenceDuration(robotSilenceVO);
        return new ResponseDto<>();
    }

}
