package com.pcloud.book.pcloudkeyword.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel("全平台关键词小号")
public class PcloudRobot extends BaseEntity {

    @ApiModelProperty("微信id")
    private String wxId;

    @ApiModelProperty("昵称")
    private String nickName;

    @ApiModelProperty("头像")
    private String head;

    @ApiModelProperty("二维码url")
    private String qrcodeUrl;

    @ApiModelProperty("个人号类型")
    private Integer robotType;

    @ApiModelProperty("分类名称")
    private String classifyName;

    @ApiModelProperty("关键词分类ID")
    private Long keywordClassifyId;

    @ApiModelProperty("关键词分类名称")
    private String keywordClassifyName;

    @ApiModelProperty("入口二维码url")
    private String entryQrcodeUrl;

    @ApiModelProperty("状态：1 在线 2 离线")
    private Integer state;

    @ApiModelProperty("小号回复欢迎语")
    private List<PcloudRobotWelcome> robotWelcomeList;

    @ApiModelProperty("缄默时长")
    private Integer silenceDuration;
}
