package com.pcloud.book.reading.check;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.reading.dao.ReadingInviteDao;
import com.pcloud.book.reading.dto.ReadingActivityAdditionParamDTO;
import com.pcloud.book.reading.dto.ReadingActivityBaseParamDTO;
import com.pcloud.book.reading.entity.ReadingInvite;
import com.pcloud.book.reading.enums.ContentTypeEnum;
import com.pcloud.book.reading.enums.JoinConditionEnum;
import com.pcloud.book.reading.enums.JoinTypeEnum;
import com.pcloud.common.utils.DateUtils;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.Date;
import java.util.List;

import lombok.extern.slf4j.Slf4j;

/**
 * @描述：参数校验
 * @作者：zhuyajie
 * @创建时间：10:05 2020/1/15
 * @版本：1.0
 */
@Component("paramCheck")
@Slf4j
public class ParamCheck {


    @Autowired
    private ReadingInviteDao readingInviteDao;


    public void checkAddParam(ReadingActivityBaseParamDTO readingActivityBaseParamDTO) {
        if (null == readingActivityBaseParamDTO) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "参数为空");
        }
        if (StringUtil.isEmpty(readingActivityBaseParamDTO.getTheme())) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "活动主题为空");
        }
        if (null == readingActivityBaseParamDTO.getBrandId()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请选择品牌方");
        }
        if (null == readingActivityBaseParamDTO.getJoinCondition()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请选择读者入群条件");
        }
        if (null == readingActivityBaseParamDTO.getJoinType()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请选择入群方式");
        }
        if (JoinConditionEnum.KEYWORD.value.equals(readingActivityBaseParamDTO.getJoinCondition()) && StringUtil.isEmpty(readingActivityBaseParamDTO.getJoinKeyword())) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写入群关键词");
        }
        if (JoinConditionEnum.TRANSFER.value.equals(readingActivityBaseParamDTO.getJoinCondition()) && null == readingActivityBaseParamDTO.getJoinAmount()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请输入进群转账金额");
        }
        if (JoinTypeEnum.QRCODE.equals(readingActivityBaseParamDTO.getJoinType()) && StringUtil.isEmpty(readingActivityBaseParamDTO.getJoinQrcodePic())) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请上传群二维码");
        }
        if (null == readingActivityBaseParamDTO.getRuleType()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写群规");
        }
        if (ContentTypeEnum.TEXT.value.equals(readingActivityBaseParamDTO.getRuleType()) && StringUtil.isEmpty(readingActivityBaseParamDTO.getRule())) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写群规内容");
        }
        if (ContentTypeEnum.FILE.value.equals(readingActivityBaseParamDTO.getRuleType()) && null == readingActivityBaseParamDTO.getRuleResourceId()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请上传群规文件");
        }
        if (ListUtils.isEmpty(readingActivityBaseParamDTO.getUserList())) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请选择邀请用户");
        }
        //群链接方式入群
        if (JoinTypeEnum.LINK.value.equals(readingActivityBaseParamDTO.getJoinType())) {
            if (null == readingActivityBaseParamDTO.getStartTime()) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写开始时间");
            }
            if (null == readingActivityBaseParamDTO.getEndTime()) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写结束时间");
            }
            if (null == readingActivityBaseParamDTO.getStartSloganType()) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写开场语");
            }
            if (ContentTypeEnum.TEXT.value.equals(readingActivityBaseParamDTO.getStartSloganType()) && StringUtil.isEmpty(readingActivityBaseParamDTO.getStartSlogan())) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写开场语内容");
            }
            if (ContentTypeEnum.FILE.value.equals(readingActivityBaseParamDTO.getStartSloganType()) && null == readingActivityBaseParamDTO.getStartResourceId()) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请上传开场语文件");
            }
            if (null == readingActivityBaseParamDTO.getEndSloganType()) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写结束语");
            }
            if (ContentTypeEnum.TEXT.value.equals(readingActivityBaseParamDTO.getEndSloganType()) && StringUtil.isEmpty(readingActivityBaseParamDTO.getEndSlogan())) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写结束语内容");
            }
            if (ContentTypeEnum.FILE.value.equals(readingActivityBaseParamDTO.getEndSloganType()) && null == readingActivityBaseParamDTO.getEndResourceId()) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请上传结束语文件");
            }
            if (DateUtils.getDateByStr(readingActivityBaseParamDTO.getEndTime()).before(DateUtils.getDateByStr(readingActivityBaseParamDTO.getStartTime()))) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "结束时间要大于开始时间");
            }
        }
        if (null == readingActivityBaseParamDTO.getInviteTime()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写邀请时间");
        }
        long diff = DateUtils.getDateDiff(DateUtils.getDateByStr(readingActivityBaseParamDTO.getInviteTime()), new Date());
//        if (diff < 1) {
//            throw new BookBizException(BookBizException.PARAM_IS_NULL, "邀请时间不能选择当天");
//        }
        if (ListUtils.isEmpty(readingActivityBaseParamDTO.getInviteList())) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写邀请语");
        }
        if (readingActivityBaseParamDTO.getInviteList().size() > 3) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "邀请语最多3条");
        }
        for (ReadingInvite readingInvite : readingActivityBaseParamDTO.getInviteList()) {
            if (null == readingInvite) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写邀请语");
            }
            readingInvite.setInviteTime(DateUtils.getDateByStr(readingActivityBaseParamDTO.getInviteTime()));
            if (null == readingInvite.getInviteTime() || null == readingInvite.getInviteType()) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写邀请语");
            }
            if (ContentTypeEnum.TEXT.value.equals(readingInvite.getInviteType()) && StringUtil.isEmpty(readingInvite.getInviteContent())) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写邀请语内容");
            }
            if (ContentTypeEnum.FILE.value.equals(readingInvite.getInviteType()) && null == readingInvite.getInviteResourceId()) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请上传邀请语文件");
            }
            if (JoinTypeEnum.LINK.value.equals(readingActivityBaseParamDTO.getJoinType()) &&
                    readingInvite.getInviteTime().after(DateUtils.getDateByStr(readingActivityBaseParamDTO.getStartTime()))) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "开始时间要大于邀请时间");
            }
        }
        if (JoinTypeEnum.QRCODE.value.equals(readingActivityBaseParamDTO.getJoinType()) && readingActivityBaseParamDTO.getUserList().size() > 500) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "选择群二维码入群方式，活动读者最多可以选择500人");
        }
    }

    public void checkAdditionParam(ReadingActivityAdditionParamDTO activityAdditionParamDTO) {
        if (null == activityAdditionParamDTO) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "参数为空");
        }
        if (null == activityAdditionParamDTO.getId()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "活动id为空");
        }
        //打卡
        if (null == activityAdditionParamDTO.getClockOpen()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写打卡设置");
        }
        if (activityAdditionParamDTO.getClockOpen()) {
            if (null == activityAdditionParamDTO.getClockResultOpen()) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写打卡成果设置");
            }
            if (StringUtil.isEmpty(activityAdditionParamDTO.getClockRemindTime()) || StringUtil.isEmpty(activityAdditionParamDTO.getClockRemindContent()) || StringUtil.isEmpty(activityAdditionParamDTO.getClockLink())) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写打卡设置");
            }
            //编辑端自定义打卡
            if (!activityAdditionParamDTO.getClockLink().contains("clock")) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写正确的打卡链接");
            }
            String clockLink = activityAdditionParamDTO.getClockLink();
            String clockId = clockLink.substring(clockLink.indexOf("/A") + 2, clockLink.indexOf("/custom/sign?"));
            if (StringUtil.isEmpty(clockId)) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写正确的打卡链接");
            }
            activityAdditionParamDTO.setClockServeId(Long.valueOf(clockId));
            activityAdditionParamDTO.setClockServeType("APP");
        } else {
            activityAdditionParamDTO.setClockResultOpen(false);
        }
        //猜谜
        if (null == activityAdditionParamDTO.getRiddleOpen()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写猜谜设置");
        }
        //奖励
        if (null == activityAdditionParamDTO.getAwardOpen()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写奖励设置");
        }
        if (activityAdditionParamDTO.getAwardOpen()) {
            if (StringUtil.isEmpty(activityAdditionParamDTO.getAwardPic()) && StringUtil.isEmpty(activityAdditionParamDTO.getAwardText())) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请填写奖励设置");
            }
        }
    }

    public void checkUpdateParam(ReadingActivityBaseParamDTO readingActivityBaseParamDTO) {
        if (null == readingActivityBaseParamDTO.getId()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "活动id为空");
        }
        List<ReadingInvite> inviteList = readingInviteDao.getByActivityId(readingActivityBaseParamDTO.getId());
        if (!ListUtils.isEmpty(inviteList)) {
            Date inviteTime = inviteList.get(0).getInviteTime();
            if (inviteTime.before(new Date())) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "活动邀请已开始，不能修改");
            }
        }
    }
}
