package com.pcloud.book.book.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 编辑做书品种统计信息
 *
 * @author guiq
 * @version 1.0
 * @since 2020年9月24日
 */
@Data
@ApiModel("编辑做书品种统计信息")
public class BookVarietyStatsDto implements Serializable {

    /**
     * 累计做书品种数
     */
    @ApiModelProperty("累计做书品种数")
    private Integer varietyTotal;
    /**
     * 上季度做书品种数
     */
    @ApiModelProperty("上季度做书品种数")
    private Integer varietyLastQuarter;
    /**
     * 本季度做书品种数
     */
    @ApiModelProperty("本季度做书品种数")
    private Integer varietyThisQuarter;

    /**
     * 累计印册量
     */
    @ApiModelProperty("累计印册量")
    private Integer printTotal;

    /**
     * 上季度印册量
     */
    @ApiModelProperty("上季度印册量")
    private Integer printLastQuarter;

    /**
     * 本季度印册量
     */
    @ApiModelProperty("本季度印册量")
    private Integer printThisQuarter;

    /**
     * 累计扫码人数
     */
    @ApiModelProperty("累计扫码人数")
    private Integer scanUserTotal;

    /**
     * 上季度扫码人数
     */
    @ApiModelProperty("上季度扫码人数")
    private Integer scanUserLastQuarter;

    /**
     * 本季度扫码人数
     */
    @ApiModelProperty("本季度扫码人数")
    private Integer scanUserThisQuarter;

    /**
     * 累计浏览人数
     */
    @ApiModelProperty("累计浏览人数")
    private Integer browseUserTotal;

    /**
     * 上季度浏览人数
     */
    @ApiModelProperty("上季度浏览人数")
    private Integer browseUserLastQuarter;

    /**
     * 本季度浏览人数
     */
    @ApiModelProperty("本季度浏览人数")
    private Integer browseUserThisQuarter;

    /**
     * 累计扫码量
     */
    @ApiModelProperty("累计扫码量")
    private Integer scanTotal;

    /**
     * 上季度扫码量
     */
    @ApiModelProperty("上季度扫码量")
    private Integer scanLastQuarter;

    /**
     * 本季度扫码量
     */
    @ApiModelProperty("本季度扫码量")
    private Integer scanThisQuarter;

    /**
     * 累计浏览量
     */
    @ApiModelProperty("累计浏览量")
    private Integer browseTotal;

    /**
     * 上季度浏览量
     */
    @ApiModelProperty("上季度浏览量")
    private Integer browseLastQuarter;

    /**
     * 本季度浏览量
     */
    @ApiModelProperty("本季度浏览量")
    private Integer browseThisQuarter;

}
