package com.pcloud.book.applet.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.applet.dto.AppletAppOrProductDTO;
import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.elasticsearch.search.aggregations.metrics.geobounds.InternalGeoBounds;

import java.util.Date;

/**
 * (ServeCollect)实体类
 *
 * @author makejava
 * @since 2020-09-10 17:38:20
 */
@Data
public class ServeCollect extends BaseEntity {

    private static final long serialVersionUID = -73442666265944368L;

    private Long id;

    @ApiModelProperty("读者id")
    private Long wechatUserId;

    @ApiModelProperty("应用id 如答案")
    private Long serveId;

    @ApiModelProperty("服务名称")
    private String serveName;

    @ApiModelProperty("应用类型 1 答案")
    private Integer serveType;

    private Integer serveCode;

    private String serveTypeCode;

    private String linkUrl;

    private String picUrl;

    @ApiModelProperty("是否删除  1 删除 0 未删除")
    private Integer isDelete;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @ApiModelProperty("收藏日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date collectDay;

    @ApiModelProperty("资源是否删除")
    private Integer sourceDelete;

    private AppletAppOrProductDTO appletAppOrProductDTO;

    private AppletNewsDTO appletNewsDTO;


}