package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.AnswerSubscribeBiz;
import com.pcloud.book.applet.biz.AppletBannerBiz;
import com.pcloud.book.applet.biz.AppletBooklistBiz;
import com.pcloud.book.applet.biz.AppletNewsBiz;
import com.pcloud.book.applet.biz.AppletStatisticBiz;
import com.pcloud.book.applet.biz.AppletUserBookcaseBiz;
import com.pcloud.book.applet.dto.AddBookParamDTO;
import com.pcloud.book.applet.dto.AnswerSubscribeDTO;
import com.pcloud.book.applet.dto.AppletBannerDTO;
import com.pcloud.book.applet.dto.AppletBooklistClassifyDTO;
import com.pcloud.book.applet.dto.AppletBooklistDTO;
import com.pcloud.book.applet.dto.AppletNewsClassifyDTO;
import com.pcloud.book.applet.dto.AppletNewsCommentDTO;
import com.pcloud.book.applet.dto.AppletNewsCustomTagDTO;
import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.dto.AppletOuterBookDTO;
import com.pcloud.book.applet.dto.AppletOuterBooklistDTO;
import com.pcloud.book.applet.dto.AppletUserBookcaseDTO;
import com.pcloud.book.applet.dto.BookDTO4Booklist;
import com.pcloud.book.applet.entity.AppletBanner;
import com.pcloud.book.applet.entity.AppletBooklist;
import com.pcloud.book.applet.entity.AppletBooklistClassify;
import com.pcloud.book.applet.entity.AppletLinkClick;
import com.pcloud.book.applet.entity.AppletNews;
import com.pcloud.book.applet.entity.AppletNewsClassify;
import com.pcloud.book.applet.entity.AppletNewsComment;
import com.pcloud.book.applet.entity.AppletNewsCustomTag;
import com.pcloud.book.applet.entity.AppletUser;
import com.pcloud.book.applet.entity.AppletUserBookcase;
import com.pcloud.book.applet.entity.AppletUserClickRecord;
import com.pcloud.book.applet.vo.AppletNewsClassifyVO;
import com.pcloud.book.applet.vo.AppletNewsShowStateVO;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.skill.biz.PcloudGroupActivityBiz;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import com.pcloud.common.utils.ParamChecker;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import com.pcloud.common.utils.string.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import java.util.List;
import java.util.Map;

@Api(description = "小睿小程序首页")
@RestController("appletHomeFacade")
@RequestMapping("appletHome")
public class AppletHomeFacade {

    @Autowired
    private AppletBooklistBiz appletBooklistBiz;
    @Autowired
    private AppletBannerBiz appletBannerBiz;
    @Autowired
    private AppletNewsBiz appletNewsBiz;
    @Autowired
    private AppletUserBookcaseBiz appletUserBookcaseBiz;
    @Autowired
    private PcloudGroupActivityBiz pcloudGroupActivityBiz;
    @Autowired
    private AppletStatisticBiz appletStatisticBiz;
    @Autowired
    private AnswerSubscribeBiz answerSubscribeBiz;

    @ApiOperation("批量名片上下架")
    @PostMapping("batchUpdateCardShowState")
    public ResponseDto<?> batchUpdateCardShowState(
            @RequestHeader("token") String token,
            @RequestBody AppletNewsShowStateVO appletNewsShowStateVO
    ) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletNewsShowStateVO || ListUtils.isEmpty(appletNewsShowStateVO.getAppletNewsIds()) || null == appletNewsShowStateVO.getBusinessCardIsOpen()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.batchUpdateCardShowState(appletNewsShowStateVO);
        return new ResponseDto<>();
    }

    @ApiOperation("更新资讯名片上架状态")
    @PostMapping("updateCardShowState")
    public ResponseDto<?> updateCardShowState(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("资讯") AppletNews appletNews) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletNews || null == appletNews.getId() || null == appletNews.getBusinessCardIsOpen()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.updateCardShowState(appletNews);
        return new ResponseDto<>();
    }



    @ApiOperation("删除咨询标签")
    @PostMapping("deleteCategoryById")
    public ResponseDto<?> deleteCategoryById(@RequestHeader("token") String token, @RequestParam("id") @ApiParam("咨询id") Long id) {
        SessionUtil.getInfoToken4Redis(token);
        appletNewsBiz.deleteCategoryById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("新增书单栏目")
    @PostMapping("addBooklistClassify")
    public ResponseDto<Long> addBooklistClassify(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("书单栏目") AppletBooklistClassify appletBooklistClassify) throws PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        appletBooklistClassify.setAgentId(agentId);
        if (null == appletBooklistClassify || StringUtil.isEmpty(appletBooklistClassify.getClassifyName())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少栏目名称");
        }
        Long id = appletBooklistBiz.addBooklistClassify(appletBooklistClassify);
        return new ResponseDto<>(id);
    }

    @ApiOperation("删除书单栏目")
    @GetMapping("deleteBooklistClassifyById")
    public ResponseDto<?> deleteBooklistClassifyById(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("书刊栏目id") Long id) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==id){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少栏目id");
        }
        appletBooklistBiz.deleteBooklistClassifyById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("修改书单栏目")
    @PostMapping("updateBooklistClassify")
    public ResponseDto<?> updateBooklistClassify(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("书单栏目")AppletBooklistClassify appletBooklistClassify) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null ==appletBooklistClassify || null==appletBooklistClassify.getId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletBooklistBiz.updateBooklistClassify(appletBooklistClassify);
        return new ResponseDto<>();
    }

    @ApiOperation("书单栏目列表")
    @GetMapping("listBooklistClassify")
    public ResponseDto<PageBeanNew<AppletBooklistClassifyDTO>> listBooklistClassify(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage,
            @RequestParam(value = "name", required = false) @ApiParam("名称查询") String name) throws PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletBooklistBiz.listBooklistClassify(currentPage, numPerPage, name, agentId));
    }

    @ApiOperation("新增书单")
    @PostMapping("addBooklist")
    public ResponseDto<Long> addBooklist(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("书单") AppletBooklist appletBooklist) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletBooklist){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        Long id = appletBooklistBiz.addBooklist(appletBooklist);
        return new ResponseDto<>(id);
    }

    @ApiOperation("删除书单")
    @GetMapping("deleteBooklistById")
    public ResponseDto<?> deleteBooklistById(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("书刊id")Long id) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==id){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少书刊id");
        }
        appletBooklistBiz.deleteBooklistById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("修改书单")
    @PostMapping("updateBooklist")
    public ResponseDto<?> updateBooklist(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("书单") AppletBooklist appletBooklist) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletBooklist || null == appletBooklist.getId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletBooklistBiz.updateBooklist(appletBooklist);
        return new ResponseDto<>();
    }

    @ApiOperation("根据id查书单")
    @GetMapping("getBooklistById")
    public ResponseDto<AppletBooklistDTO> getBooklistById(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("书刊id")Long id) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==id){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少书刊id");
        }
        return new ResponseDto<>(appletBooklistBiz.getBooklistById(id));
    }

    @ApiOperation("书单管理列表")
    @GetMapping("listBooklist")
    public ResponseDto<PageBeanNew<AppletBooklistDTO>> listBooklist(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage,
            @RequestParam(value = "name", required = false) @ApiParam("名称查询") String name,
            @RequestParam(value = "classifyId", required = false) @ApiParam("书单栏目id") Long classifyId,
            @RequestParam(value = "firstClassify", required = false) @ApiParam("一级书刊分类") Long firstClassify,
            @RequestParam(value = "secondClassify", required = false) @ApiParam("二级书刊分类")Long secondClassify,
            @RequestParam(value = "gradeLabelId", required = false) @ApiParam("年级标签")Long gradeLabelId,
            @RequestParam(value = "subjectLabelId", required = false) @ApiParam("科目标签")Long subjectLabelId,
            @RequestParam(value = "relateAgentId", required = false) @ApiParam("书单所属出版")Long relateAgentId
    ) throws PermissionException {
            Map<String, Object> map = SessionUtil.getToken4Redis(token);
            Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletBooklistBiz.listBooklist(currentPage, numPerPage, name, classifyId, agentId, firstClassify,secondClassify,
                gradeLabelId,subjectLabelId, relateAgentId));
    }

    @ApiOperation("书单添加图书")
    @PostMapping("addBookToBooklist")
    public ResponseDto<?> addBookToBooklist(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("添加图书参数") AddBookParamDTO addBookParamDTO) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == addBookParamDTO || null == addBookParamDTO.getBooklistId() || ListUtils.isEmpty(addBookParamDTO.getBookDTO4Booklists())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        for (BookDTO4Booklist bookDTO : addBookParamDTO.getBookDTO4Booklists()){
            if (null==bookDTO.getBookId() || null==bookDTO.getAdviserId() ||null == bookDTO.getChannelId()){
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少bookId/adviserId/channelId");
            }
        }
        appletBooklistBiz.addBookToBooklist(addBookParamDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("新增banner")
    @PostMapping("addBanner")
    public ResponseDto<Long> addBanner(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("banner") AppletBanner appletBanner) throws PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        if (null == appletBanner){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletBanner.setAgentId(agentId);
        Long id = appletBannerBiz.addBanner(appletBanner);
        return new ResponseDto<>(id);
    }

    @ApiOperation("修改banner")
    @PostMapping("updateBanner")
    public ResponseDto<?> updateBanner(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("banner") AppletBanner appletBanner) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletBanner || null == appletBanner.getId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletBannerBiz.updateBanner(appletBanner);
        return new ResponseDto<>();
    }

    @ApiOperation("删除banner")
    @GetMapping("deleteBanner")
    public ResponseDto<?> deleteBanner(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("bannerId")Long id) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==id){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少bannerId");
        }
        appletBannerBiz.deleteBanner(id);
        return new ResponseDto<>();
    }

    @ApiOperation("根据id查banner")
    @GetMapping("getBannerById")
    public ResponseDto<AppletBannerDTO> getBannerById(
            @RequestHeader("token") String token,
            @RequestParam("bannerId") @ApiParam("bannerId")Long id) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==id){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少bannerId");
        }
        return new ResponseDto<>(appletBannerBiz.getBannerById(id));
    }

    @ApiOperation("banner列表")
    @GetMapping("listBanner")
    public ResponseDto<PageBeanNew<AppletBannerDTO>> listBanner(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage) throws PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletBannerBiz.listBanner(currentPage, numPerPage,null, agentId));
    }

    @ApiOperation("客户端banner列表")
    @GetMapping("listBanner4Wechat")
    public ResponseDto<PageBeanNew<AppletBannerDTO>> listBanner4Wechat(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage) {
        Long officialAccountsId = Cookie.getId(userInfo,Cookie._OFFICIAL_ACCOUNTS_ID);
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);

        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletBannerBiz.listBanner4Wechat(currentPage, numPerPage, true, officialAccountsId, wechatUserId));
    }

    @ApiOperation("获取书单下书籍列表")
    @GetMapping("listPageBook4AppletBooklist")
    public ResponseDto<PageBeanNew<BookDTO4Booklist>> listPageBook4AppletBooklist(
            @RequestHeader("token") String token,
            @RequestParam("booklistId") @ApiParam("书单id") Long booklistId,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==booklistId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少书单id");
        }
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletBooklistBiz.listPageBook4AppletBooklist(booklistId,currentPage,numPerPage));
    }

    @ApiOperation("更新书籍排序")
    @GetMapping("updateBookSeq")
    public ResponseDto<?> updateBookSeq(
            @RequestHeader("token") String token,
            @RequestParam("configId") @ApiParam("配置id") Long configId,
            @RequestParam("seq") @ApiParam("排序值")Integer seq) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==configId || null == seq){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少参数");
        }
        appletBooklistBiz.updateBookSeq(configId, seq);
        return new ResponseDto<>();
    }

    @ApiOperation("获取所有书单栏目")
    @GetMapping("getAllBooklistClassify")
    public ResponseDto<List<AppletBooklistClassifyDTO>> getAllBooklistClassify(
            @RequestHeader("token") String token,
            @RequestParam(value = "showState", required = false) @ApiParam("是否展示") Boolean showState){
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(appletBooklistBiz.getAllBooklistClassify(showState, agentId));
    }

    @ApiOperation("客户端获取书单列表")
    @GetMapping("listBooklist4Wechat")
    public ResponseDto<PageBeanNew<AppletBooklistDTO>> listBooklist4Wechat(
            @CookieValue("userInfo") String userInfo,
            @RequestParam(value = "classifyId", required = false) @ApiParam("书单栏目id") Long classifyId,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo,Cookie._OFFICIAL_ACCOUNTS_ID);
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletBooklistBiz.listBooklist4Wechat(classifyId,currentPage,numPerPage,wechatUserId,officialAccountsId));
    }

    @ApiOperation("客户端根据id获取书单")
    @GetMapping("getBooklistById4Wechat")
    public ResponseDto<AppletBooklistDTO> getBooklistById4Wechat(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("booklistId") @ApiParam("书单id")Long booklistId){
        if (null==booklistId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletBooklistBiz.getBooklistById4Wechat(booklistId));
    }

    @ApiOperation("新增资讯栏目")
    @PostMapping("addAppletNewsClassify")
    public ResponseDto<Long> addAppletNewsClassify(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("资讯栏目") AppletNewsClassify appletNewsClassify) throws PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        if (null == appletNewsClassify){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsClassify.setAgentId(agentId);
        return new ResponseDto<>(appletNewsBiz.addAppletNewsClassify(appletNewsClassify));
    }

    @ApiOperation("修改资讯栏目")
    @PostMapping("updateAppletNewsClassify")
    public ResponseDto<?> updateAppletNewsClassify(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("资讯栏目")AppletNewsClassify appletNewsClassify) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletNewsClassify || null == appletNewsClassify.getId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.updateAppletNewsClassify(appletNewsClassify);
        return new ResponseDto<>();
    }

    @ApiOperation("删除资讯栏目")
    @GetMapping("deleteNewsClassifyById")
    public ResponseDto<?> deleteNewsClassifyById(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("资讯栏目")Long id) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == id){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.deleteNewsClassifyById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("资讯栏目列表")
    @GetMapping("listNewsClassify")
    public ResponseDto<PageBeanNew<AppletNewsClassifyDTO>> listNewsClassify(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage,
            @RequestParam(value = "name", required = false) @ApiParam("名称查询") String name) throws PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletNewsBiz.listNewsClassify(currentPage, numPerPage, name, agentId));
    }

    @ApiOperation("获取所有资讯栏目")
    @GetMapping("getAllNewsClassify")
    public ResponseDto<List<AppletNewsClassifyDTO>> getAllNewsClassify(
            @RequestHeader("token") String token,
            @RequestParam(value = "showState", required = false) @ApiParam("是否展示") Boolean showState){
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(appletNewsBiz.getAllNewsClassify(showState, agentId));
    }

    @ApiOperation("添加资讯")
    @PostMapping("addAppletNews")
    public ResponseDto<Long> addAppletNews(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("资讯") AppletNews appletNews) throws PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        if (null == appletNews){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNews.setAgentId(agentId);
        return new ResponseDto<>(appletNewsBiz.addAppletNews(appletNews));
    }

    @ApiOperation("修改资讯")
    @PostMapping("updateAppletNews")
    public ResponseDto<?> updateAppletNews(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("资讯") AppletNews appletNews) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletNews || null == appletNews.getId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.updateAppletNews(appletNews);
        return new ResponseDto<>();
    }

    @ApiOperation("删除资讯")
    @GetMapping("deleteAppletNewsById")
    public ResponseDto<?> deleteAppletNewsById(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("资讯id") Long id) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == id){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.deleteAppletNewsById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("资讯列表")
    @GetMapping("listAppletNews")
    public ResponseDto<PageBeanNew<AppletNewsDTO>> listAppletNews(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage,
            @RequestParam(value = "name", required = false) @ApiParam("名称查询") String name,
            @RequestParam(value = "firstClassify", required = false) @ApiParam("一级书刊分类") Long firstClassify,
            @RequestParam(value = "secondClassify", required = false) @ApiParam("二级书刊分类")Long secondClassify,
            @RequestParam(value = "gradeLabelId", required = false) @ApiParam("年级标签")Long gradeLabelId,
            @RequestParam(value = "subjectLabelId", required = false) @ApiParam("科目标签")Long subjectLabelId,
            @RequestParam(value = "rightsClassifyId", required = false) @ApiParam("权益分类") Long rightsClassifyId,
            @RequestParam(value = "source", required = false) @ApiParam("来源") String source,
            @RequestParam(value = "showState", required = false) @ApiParam("上架") Integer showState,
            @RequestParam(value = "newsClassifyId", required = false) @ApiParam("资讯栏目id") Long newsClassifyId,
            @RequestParam(value = "customTagId", required = false) @ApiParam("自定义标识id") Long customTagId,
            @RequestParam(value = "cityCode", required = false) @ApiParam("城市筛选") String cityCode
            ) throws PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletNewsBiz.listAppletNews(currentPage, numPerPage, name, firstClassify,secondClassify,gradeLabelId,
                subjectLabelId,rightsClassifyId,source,showState,newsClassifyId,customTagId, cityCode,agentId));
    }

    @ApiOperation("客户端资讯列表")
    @GetMapping("listAppletNews4Wechat")
    public ResponseDto<PageBeanNew<AppletNewsDTO>> listAppletNews4Wechat(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage,
            @RequestParam(value = "newsClassifyId", required = false) @ApiParam("资讯栏目id") Long newsClassifyId) {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletNewsBiz.listAppletNews4Wechat(currentPage, numPerPage, newsClassifyId, wechatUserId, officialAccountsId));
    }

    @ApiOperation("添加资讯评论")
    @PostMapping("addAppletNewsComment")
    public ResponseDto<?> addAppletNewsComment(
            @CookieValue("userInfo") String userInfo,
            @RequestBody @ApiParam("资讯评论") AppletNewsComment appletNewsComment){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        if (null==appletNewsComment || null == appletNewsComment.getNewsId() || StringUtil.isEmpty(appletNewsComment.getComment())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.addAppletNewsComment(appletNewsComment,wechatUserId);
        return new ResponseDto<>();
    }

    @ApiOperation("查询资讯评论列表")
    @GetMapping("listNewsCommentByNewsId")
    public ResponseDto<PageBeanNew<AppletNewsCommentDTO>> listNewsCommentByNewsId(
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage,
            @RequestParam("newsId") @ApiParam("资讯id") Long newsId){
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        if (null == newsId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少资讯id");
        }
        return new ResponseDto<>(appletNewsBiz.listNewsCommentByNewsId(currentPage, numPerPage, newsId));
    }

    @ApiOperation("添加图书到书架")
    @PostMapping("addUserBook")
    public ResponseDto<?> addUserBook(
            @CookieValue("userInfo") String userInfo,
            @RequestBody @ApiParam("图书") AppletUserBookcase appletUserBookcase){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        if (null == appletUserBookcase || null == appletUserBookcase.getBookId() || null == appletUserBookcase.getAdviserId()
            || null == appletUserBookcase.getChannelId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletUserBookcase.setWechatUserId(wechatUserId);
        appletUserBookcaseBiz.addUserBook(appletUserBookcase);
        return new ResponseDto<>();
    }

    @ApiOperation("查用户书架列表")
    @GetMapping("listUserBookcaseByWechatUserId")
    public ResponseDto<PageBeanNew<AppletUserBookcaseDTO>> listUserBookcaseByWechatUserId(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletUserBookcaseBiz.listByWechatUserId(wechatUserId,currentPage,numPerPage));
    }

    @ApiOperation("小程序首页书籍信息")
    @GetMapping("getUserBookInfoByWechatUserId")
    public ResponseDto<AppletUserBookcaseDTO> getUserBookInfoByWechatUserId (
            @CookieValue("userInfo") String userInfo,
            @RequestParam(value = "bookId") @ApiParam("BookId") Long bookId,
            @RequestParam(value = "channelId") @ApiParam("channelId") Long channelId,
            @RequestParam(value = "rightsSettingId",required = false) @ApiParam("rightsSettingId") String rightsSettingId,
            @RequestParam(value = "adviserId") @ApiParam("adviserId") Long adviserId){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        Long rightsSettingId4Num = null;
        if (NumberUtil.isNumber(rightsSettingId)) {
            rightsSettingId4Num = NumberUtil.toLong(rightsSettingId);
        }
        return new ResponseDto<>(appletUserBookcaseBiz.getUserBookInfoByWechatUserId(bookId,channelId,adviserId,rightsSettingId4Num));
    }

    @ApiOperation("新增用户资源点击记录")
    @PostMapping("addUserClickRecord")
    public ResponseDto<?>  addUserClickRecord(
            @CookieValue("userInfo") String userInfo,
            @RequestBody @ApiParam("资源点击记录") AppletUserClickRecord appletUserClickRecord){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        if (null == appletUserClickRecord || null == appletUserClickRecord.getBookId()
            || null == appletUserClickRecord.getFromId() ||StringUtil.isEmpty(appletUserClickRecord.getFromType())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletUserClickRecord.setWechatUserId(wechatUserId);
        appletUserBookcaseBiz.addUserClickRecord(appletUserClickRecord);
        return new ResponseDto<>();
    }

    @ApiOperation("用户图书资源点击统计")
    @GetMapping("getUserClickStatistic")
    public ResponseDto<Map<String,Object>> getUserClickStatistic(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("bookId") @ApiParam("图书id")Long bookId,
            @RequestParam("channelId") @ApiParam("运营id")Long channelId,
            @RequestParam("adviserId") @ApiParam("编辑id")Long adviserId){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        if (null == bookId || null== channelId || null == adviserId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        return new ResponseDto<>(appletUserBookcaseBiz.getUserClickStatistic(wechatUserId,bookId,channelId,adviserId));
    }

    @ApiOperation("根据ID查资讯详情")
    @GetMapping("getAppletNewsById")
    public ResponseDto<AppletNewsDTO> getAppletNewsById(
            @RequestParam("newsId") @ApiParam("资讯id")Long newsId){
        if (null == newsId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        return new ResponseDto<>(appletNewsBiz.getNewsById4Applet(newsId));
    }

    @ApiOperation("查图书详情-出版作者分类书名")
    @GetMapping("getByBookIdAdviserChannel")
    public ResponseDto<BookDTO4Booklist> getByBookIdAdviserChannel(
            @RequestParam("adviserId") @ApiParam("编辑id")Long adviserId,
            @RequestParam("channelId") @ApiParam("运营id")Long channelId,
            @RequestParam("bookId") @ApiParam("图书id")Long bookId){
        if (null == bookId || null== channelId || null == adviserId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        return new ResponseDto<>(appletBooklistBiz.getByBookIdAdviserChannel(adviserId, channelId, bookId));
    }

    @ApiOperation("更新资讯上架状态")
    @PostMapping("updateNewsShowState")
    public ResponseDto<?> updateNewsShowState(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("资讯") AppletNews appletNews) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletNews || null == appletNews.getId() || null == appletNews.getShowState()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.updateNewsShowState(appletNews);
        return new ResponseDto<>();
    }

    @ApiOperation("获取用户最后一次点击的书（有社群书的取最后一次社群书，没有的取现代纸书）")
    @GetMapping("getUserLastBookRe")
    public ResponseDto<?> getUserLastBookRe(
            @CookieValue("userInfo") String userInfo
    ) throws PermissionException{
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletUserBookcaseBiz.getUserLastBookRe(wechatUserId));
    }

    @ApiOperation("获取社群共读")
    @GetMapping("getGroupActivity4Applet")
    public ResponseDto<?> getGroupActivity4Applet(
        @CookieValue("userInfo") String userInfo,
        @RequestParam(value = "adviserId") Long adviserId,
        @RequestParam(value = "bookId") Long bookId,
        @RequestParam(value = "rightsSettingId") Long rightsSettingId,
        @RequestParam(value = "channelId") Long channelId,
        @RequestParam(value = "readType",required = false)@ApiParam("阅读方式1轻松2高效3深度") Integer readType
        ) {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        if (null == wechatUserId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        return new ResponseDto<>(pcloudGroupActivityBiz.getGroupActivity4Applet(rightsSettingId, adviserId ,bookId, channelId, readType));
    }

    @ApiOperation("资讯来源列表")
    @GetMapping("getNewsSourceList")
    public ResponseDto<List<String>> getNewsSourceList(@RequestHeader("token") String token){
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(appletNewsBiz.getNewsSourceList(agentId));
    }

    @ApiOperation("批量修改分类")
    @PostMapping("batchUpdateClassify")
    public ResponseDto<?> batchUpdateClassify(
        @RequestHeader("token") String token,
        @RequestBody AppletNewsClassifyVO appletNewsClassifyVO
    ) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        appletNewsBiz.batchUpdateClassify(appletNewsClassifyVO);
        return new ResponseDto<>();
    }

    @ApiOperation("批量上下架")
    @PostMapping("batchUpdateShowState")
    public ResponseDto<?> batchUpdateShowState(
        @RequestHeader("token") String token,
        @RequestBody AppletNewsShowStateVO appletNewsShowStateVO
    ) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletNewsShowStateVO || ListUtils.isEmpty(appletNewsShowStateVO.getAppletNewsIds()) || null == appletNewsShowStateVO.getShowState()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.batchUpdateShowState(appletNewsShowStateVO);
        return new ResponseDto<>();
    }

    @ApiOperation("批量删除")
    @PostMapping("batchDeleteAppletNews")
    public ResponseDto<?> batchDeleteAppletNews(
        @RequestHeader("token") String token,
        @RequestBody List<Long> appletNewsIds
    ) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (ListUtils.isEmpty(appletNewsIds)){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.batchDeleteAppletNews(appletNewsIds);
        return new ResponseDto<>();
    }

    @ApiOperation("删除书架记录")
    @PostMapping("deleteBookcaseRecordByIds")
    public ResponseDto<?> deleteBookcaseRecordByIds(@CookieValue("userInfo") String userInfo, @RequestBody List<Long> ids) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        appletUserBookcaseBiz.deleteByIds(ids, wechatUserId);
        return new ResponseDto<>();
    }

    @ApiOperation("资讯和券的资源外链访问埋点")
    @PostMapping("addClickRecord")
    public ResponseDto<?> addClickRecord(@CookieValue("userInfo") String userInfo, @RequestBody @Validated AppletLinkClick appletLinkClick){
        if (null==appletLinkClick){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        appletNewsBiz.addClickRecord(appletLinkClick);
        return new ResponseDto<>();
    }

    @ApiOperation("根据链接地址获取外链编号")
    @GetMapping("getUrlNumberByUrl")
    public ResponseDto<String> getUrlNumberByUrl(@RequestHeader("token") String token,
                                                 @RequestParam(value = "url",required = false) String url){
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(appletNewsBiz.getUrlNumberByUrl(url, agentId));
    }

    @ApiOperation("资讯统计分析")
    @GetMapping("listAppletNews4Analysis")
    public ResponseDto<PageBeanNew<AppletNewsDTO>> listAppletNews4Analysis(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage,
            @RequestParam(value = "name", required = false) @ApiParam("名称/外链编号查询") String name,
            @RequestParam(value = "firstClassify", required = false) @ApiParam("一级书刊分类") Long firstClassify,
            @RequestParam(value = "secondClassify", required = false) @ApiParam("二级书刊分类") Long secondClassify,
            @RequestParam(value = "gradeLabelId", required = false) @ApiParam("年级标签") Long gradeLabelId,
            @RequestParam(value = "subjectLabelId", required = false) @ApiParam("科目标签") Long subjectLabelId,
            @RequestParam(value = "linkOnly", required = false) @ApiParam("只看第三方") Integer linkOnly,
            @RequestParam(value = "source", required = false) @ApiParam("来源") String source,
            @RequestParam(value = "browseQty", required = false) @ApiParam("浏览量") Integer browseQty,
            @RequestParam(value = "clickQty", required = false) @ApiParam("点击量") Integer clickQty,
            @RequestParam(value = "rightsClassifyId", required = false) @ApiParam("权益分类") Long rightsClassifyId
    ) throws PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        if (null == currentPage || null == numPerPage) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少分页参数");
        }
        return new ResponseDto<>(appletNewsBiz.listAppletNews4Analysis(currentPage, numPerPage, name, firstClassify, secondClassify, gradeLabelId,
                subjectLabelId, linkOnly,rightsClassifyId,source,browseQty,clickQty, agentId));
    }


    @ApiOperation("用户选择资讯栏目")
    @PostMapping("addUserNewsClassify")
    public ResponseDto<?> addUserNewsClassify(@CookieValue("userInfo") String userInfo, @RequestBody List<Long> newsClassifyIds){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        appletNewsBiz.addUserNewsClassify(newsClassifyIds,wechatUserId, officialAccountsId);
        return new ResponseDto<>();
    }

    @ApiOperation("所有资讯栏目列表+用户选择的资讯栏目")
    @GetMapping("getAllNewsClassify4Wechat")
    public ResponseDto<List<AppletNewsClassifyDTO>> getAllNewsClassify4Wechat(@CookieValue("userInfo") String userInfo){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        return new ResponseDto<>(appletNewsBiz.getAllNewsClassify4Wechat(wechatUserId, officialAccountsId));
    }

    @ApiOperation("用户选择的资讯栏目")
    @GetMapping("getNewsClassifyByUser")
    public ResponseDto<List<AppletNewsClassifyDTO>> getNewsClassifyByUser(@CookieValue("userInfo") String userInfo){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        return new ResponseDto<>(appletNewsBiz.getNewsClassifyByUser(wechatUserId, officialAccountsId));
    }

    @ApiOperation("用户选择书单栏目")
    @PostMapping("addUserBooklistClassify")
    public ResponseDto<?> addUserBooklistClassify(@CookieValue("userInfo") String userInfo, @RequestBody List<Long> classifyIds) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo,Cookie._OFFICIAL_ACCOUNTS_ID);
        appletBooklistBiz.addUserBooklistClassify(classifyIds, wechatUserId, officialAccountsId);
        return new ResponseDto<>();
    }

    @ApiOperation("所有书单栏目列表+用户选择的书单栏目")
    @GetMapping("getAllBooklistClassify4Wechat")
    public ResponseDto<List<AppletBooklistClassifyDTO>> getAllBooklistClassify4Wechat(@CookieValue("userInfo") String userInfo) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo,Cookie._OFFICIAL_ACCOUNTS_ID);
        return new ResponseDto<>(appletBooklistBiz.getAllBooklistClassify4Wechat(wechatUserId, officialAccountsId));
    }

    @ApiOperation("用户选择的书单栏目")
    @GetMapping("getBooklistClassifyByUser")
    public ResponseDto<List<AppletBooklistClassifyDTO>> getBooklistClassifyByUser(@CookieValue("userInfo") String userInfo) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo,Cookie._OFFICIAL_ACCOUNTS_ID);
        return new ResponseDto<>(appletBooklistBiz.getBooklistClassifyByUser(wechatUserId, officialAccountsId));
    }

    @ApiOperation("已读书刊随机换一本书展示")
    @GetMapping("randomChangeBook")
    public ResponseDto<?> randomChangeBook(@CookieValue("userInfo") String userInfo){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        appletUserBookcaseBiz.randomChangeBook(wechatUserId);
        return new ResponseDto<>();
    }


    @ApiOperation("更新读者关于本书的阅读方式")
    @PostMapping("updateUserReadType")
    public ResponseDto<?> updateUserReadType(
            @CookieValue("userInfo") String userInfo,
            @RequestBody @ApiParam("图书") AppletUserBookcase appletUserBookcase){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        if (null == appletUserBookcase || null == appletUserBookcase.getBookId() || null == appletUserBookcase.getAdviserId()
                || null == appletUserBookcase.getChannelId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletUserBookcase.setWechatUserId(wechatUserId);
        appletUserBookcaseBiz.updateUserReadType(appletUserBookcase);
        return new ResponseDto<>();
    }

    @ApiOperation("获取用户当前本书的阅读方式")
    @GetMapping("getUserReadType")
    public ResponseDto<AppletUserBookcase> getUserReadType(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("bookId") Long bookId,
            @RequestParam("adviserId") Long adviserId,
            @RequestParam("channelId") Long channelId) {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        if (null == bookId || null == adviserId || null == channelId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        AppletUserBookcase appletUserBookcase = appletUserBookcaseBiz.getUserReadType(wechatUserId,bookId,adviserId,channelId);
        return new ResponseDto<>(appletUserBookcase);
    }

    @ApiOperation("批量修改资讯所属栏目")
    @PostMapping("batchUpdateNewsClassify")
    public ResponseDto<?> batchUpdateNewsClassify(
            @RequestHeader("token") String token,
            @RequestBody AppletNewsClassifyVO appletNewsClassifyVO
    ) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        appletNewsBiz.batchUpdateNewsClassify(appletNewsClassifyVO);
        return new ResponseDto<>();
    }

    @ApiOperation("用户已读书刊记录id列表")
    @GetMapping("getBookcaseIdListByUser")
    public ResponseDto<?> getBookcaseIdListByUser(@CookieValue("userInfo") String userInfo){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw BookBizException.PARAM_DELETION;
        }
        return new ResponseDto<>(appletUserBookcaseBiz.getBookcaseIdListByUser(wechatUserId));
    }

    @ApiOperation("批量更新资讯自定义标识")
    @PostMapping("batchUpdateCustomTagId")
    public ResponseDto<?> batchUpdateCustomTagId(@RequestHeader("token") String token, @RequestBody AppletNewsCustomTagDTO appletNewsCustomTagDTO) {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        if (null == appletNewsCustomTagDTO) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "参数为空");
        }
        appletNewsBiz.batchUpdateCustomTagId(appletNewsCustomTagDTO.getNewsIds(), appletNewsCustomTagDTO.getCustomTagId(), appletNewsCustomTagDTO.getCustomTag(),agentId);
        return new ResponseDto<>();
    }

    @ApiOperation("新增资讯自定义标识")
    @PostMapping("insertCustomTag")
    public ResponseDto<?> insertCustomTag(@RequestHeader("token") String token, @RequestBody AppletNewsCustomTag appletNewsCustomTag) {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        appletNewsCustomTag.setAgentId(agentId==null?0L:agentId);
        return new ResponseDto<>(appletNewsBiz.insertCustomTag(appletNewsCustomTag));
    }

    @ApiOperation("修改资讯自定义标识")
    @PostMapping("updateCustomTag")
    public ResponseDto<?> updateCustomTag(@RequestHeader("token") String token, @RequestBody AppletNewsCustomTag appletNewsCustomTag) {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        appletNewsCustomTag.setAgentId(agentId==null?0L:agentId);
        appletNewsBiz.updateCustomTag(appletNewsCustomTag);
        return new ResponseDto<>();
    }

    @ApiOperation("资讯自定义标识列表")
    @GetMapping("getNewsCustomTagList")
    public ResponseDto<?> getNewsCustomTagList(@RequestHeader("token") String token) {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(appletNewsBiz.getCustomTagList(agentId));
    }

    @ApiOperation("根据标识id查资讯id列表")
    @GetMapping("getNewsIdListByCustomTagId")
    public ResponseDto<?> getNewsIdListByCustomTagId(@RequestParam("customTagId") Long customTagId) {
        return new ResponseDto<>(appletNewsBiz.getNewsIdListByCustomTagId(customTagId));
    }

    @ApiOperation("添加/修改外部书刊")
    @PostMapping("addOuterBook")
    public ResponseDto<?> addOuterBook(@RequestHeader("token") String token, @RequestBody AppletOuterBookDTO appletOuterBookDTO) {
        Map<String,Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        appletOuterBookDTO.setAgentId(agentId==null?0L:agentId);
        return new ResponseDto<>(appletBooklistBiz.addOuterBook(appletOuterBookDTO));
    }

    @ApiOperation("根据id查外部书刊")
    @GetMapping("getOuterBookById")
    public ResponseDto<?> getByOuterBookId(@RequestHeader("token") String token, @RequestParam("outerBookId") Long outerBookId) {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(appletBooklistBiz.getOuterBookById(outerBookId));
    }

    @ApiOperation("外部书刊分页查询")
    @GetMapping("listPageOuterBook")
    public ResponseDto<?> listPageOuterBook(@RequestHeader("token") String token,
                                            @RequestParam("currentPage") Integer currentPage,
                                            @RequestParam("numPerPage") Integer numPerPage,
                                            @RequestParam(value = "publish", required = false) String publish,
                                            @RequestParam(value = "name", required = false) String name) {
        Map<String,Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(appletBooklistBiz.listPageOuterBook(currentPage, numPerPage, publish, name, agentId));
    }

    @ApiOperation("外部书刊出版社列表")
    @GetMapping("getOuterBookPublish")
    public ResponseDto<?> getAllPublish(@RequestHeader("token") String token) {
        Map<String,Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(appletBooklistBiz.getOuterBookPublish(agentId));
    }

    @ApiOperation("删除外部书刊")
    @GetMapping("deleteOuterBookById")
    public ResponseDto<?> deleteOuterBookById(@RequestHeader("token") String token, @RequestParam("outerBookId") Long outerBookId) {
        SessionUtil.getToken4Redis(token);
        appletBooklistBiz.deleteOuterBookById(outerBookId);
        return new ResponseDto<>();
    }

    @ApiOperation("创建外部书单")
    @PostMapping("addOuterBooklist")
    public ResponseDto<?> addOuterBooklist(@RequestHeader("token") String token, @RequestBody AppletOuterBooklistDTO appletOuterBooklistDTO) {
        Map<String,Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        appletOuterBooklistDTO.setAgentId(agentId==null?0L:agentId);
        return new ResponseDto<>(appletBooklistBiz.addOuterBooklist(appletOuterBooklistDTO));
    }

    @ApiOperation("外部书单查询")
    @GetMapping("getOuterBooklistById")
    public ResponseDto<?> getOuterBooklistById(@RequestHeader("token") String token, @RequestParam("booklistId") Long booklistId) {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(appletBooklistBiz.getOuterBooklistById(booklistId));
    }

    @ApiOperation("外部书单列表")
    @GetMapping("listPageOuterBooklist")
    public ResponseDto<?> listPageOuterBooklist(@RequestHeader("token") String token,
                                                @RequestParam("currentPage") Integer currentPage,
                                                @RequestParam("numPerPage") Integer numPerPage,
                                                @RequestParam(value = "publish", required = false) String publish,
                                                @RequestParam(value = "name", required = false) String name) {
        Map<String,Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(appletBooklistBiz.listPageOuterBooklist(currentPage, numPerPage, publish, name, agentId));
    }

    @ApiOperation("外部书单出版社列表")
    @GetMapping("getOuterBooklistPublish")
    public ResponseDto<?> getOuterBooklistPublish(@RequestHeader("token") String token) {
        Map<String,Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(appletBooklistBiz.getOuterBooklistPublish(agentId));
    }

    @ApiOperation("删除外部书单")
    @GetMapping("deleteOuterBooklistById")
    public ResponseDto<?> deleteOuterBooklistById(@RequestHeader("token") String token, @RequestParam("booklistId") Long booklistId) {
        SessionUtil.getToken4Redis(token);
        appletBooklistBiz.deleteOuterBooklistById(booklistId);
        return new ResponseDto<>();
    }

    @ApiOperation("客户端-查外部书单及书刊列表")
    @GetMapping("getOutBooklistById4Wechat")
    public ResponseDto<?> getOutBooklistById4Wechat(@RequestParam("booklistId") Long booklistId){
        return new ResponseDto<>(appletBooklistBiz.getOutBooklistById4Wechat(booklistId));
    }

    @ApiOperation("批量从外部书单中移出书刊")
    @PostMapping("batchDeleteOuterBookFromBooklist")
    public ResponseDto<?>batchDeleteOuterBookFromBooklist(@RequestHeader("token")String token, @RequestBody List<Long> configIds){
        SessionUtil.getToken4Redis(token);
        appletBooklistBiz.batchDeleteOuterBookFromBooklist(configIds);
        return new ResponseDto<>();
    }

    @ApiOperation("根据书单id查外部书刊分页查询")
    @GetMapping("listPageOuterBookByBooklistId")
    public ResponseDto<?> listPageOuterBookByBooklistId(@RequestHeader("token") String token,
                                            @RequestParam("currentPage") Integer currentPage,
                                            @RequestParam("numPerPage") Integer numPerPage,
                                            @RequestParam("booklistId") Long booklistId) {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(appletBooklistBiz.listPageOuterBookByBooklistId(currentPage, numPerPage, booklistId));
    }

    @ApiOperation("小程序用户埋点")
    @PostMapping("addRecord")
    public ResponseDto<?> addRecord(@RequestBody @ApiParam AppletUser appletUser) {
        appletStatisticBiz.addRecord(appletUser);
        return new ResponseDto<>();
    }

    @ApiOperation("小睿管理端小程序统计数据")
    @GetMapping("getStatisticByTime4AppletAgent")
    public ResponseDto<?> getStatisticByTime4AppletAgent(@RequestHeader("token") String token,
                                                         @RequestParam(value = "startTime", required = false) String startTime,
                                                         @RequestParam(value = "endTime", required = false) String endTime) {
        Long agentId = (Long) SessionUtil.getVlaue(token, SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(appletStatisticBiz.getStatisticByAgentAndTime(agentId, startTime, endTime));
    }

    @ApiOperation("小睿管理端小程序统计数据（累计数据）")
    @GetMapping("getStatistic4AppletAgent")
    public ResponseDto<?> getStatistic4AppletAgent(@RequestHeader("token") String token) {
        Long agentId = (Long) SessionUtil.getVlaue(token, SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(appletStatisticBiz.getStatisticByAgent(agentId));
    }

    @ApiOperation("获取推荐书单")
    @GetMapping("getRecommendBooklist")
    public ResponseDto<?> getRecommendBooklist(
            @RequestParam("bookId") Long bookId,
            @RequestParam("adviserId") Long adviserId,
            @RequestParam("channelId") Long channelId){
        if (null == bookId || null == adviserId || null == channelId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        return new ResponseDto<>(appletBooklistBiz.getRecommendBooklistByBook(bookId, adviserId, channelId));
    }

    @ApiOperation("根据书刊分类自动创建书单")
    @GetMapping("autoCreateBooklistByTemplet")
    public ResponseDto<?> autoCreateBooklistByTemplet(@RequestParam("firstClassify") Long firstClassify){
        if (null != firstClassify){
            appletBooklistBiz.autoCreateBooklistByTemplet(firstClassify);
        }
        return new ResponseDto<>();
    }

    @RequestMapping(value = "getResources4Books", method = RequestMethod.POST, consumes = {
            MediaType.MULTIPART_FORM_DATA_VALUE}, produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseDto<String> getResources4Books(MultipartHttpServletRequest request) {
        String url = appletUserBookcaseBiz.getResources4Books(request);
        return new ResponseDto<>(url);
    }

    @ApiOperation("答案订阅")
    @PostMapping("answerSubscribe")
    public ResponseDto<?> answerSubscribe(
            @CookieValue("userInfo") String userInfo,
            @RequestBody @ApiParam AnswerSubscribeDTO answerSubscribeDTO){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long accountSettingId = Cookie.getId(userInfo,Cookie._OFFICIAL_ACCOUNTS_ID);
        if (null == answerSubscribeDTO){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        answerSubscribeDTO.setWechatUserId(wechatUserId);
        answerSubscribeDTO.setAccountSettingId(accountSettingId);
        answerSubscribeBiz.answerSubscribe(answerSubscribeDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("查看答案订阅状态")
    @PostMapping("getSubscribeState")
    public ResponseDto<?> getSubscribeState(
            @CookieValue("userInfo") String userInfo,
            @RequestBody @ApiParam AnswerSubscribeDTO answerSubscribeDTO){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if (null == answerSubscribeDTO){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        answerSubscribeDTO.setWechatUserId(wechatUserId);
        return new ResponseDto<>(answerSubscribeBiz.getSubscribeState(answerSubscribeDTO));
    }

    @ApiOperation("小程序首页banner点击埋点")
    @RequestMapping(value = "/bannerClickRecord", method = RequestMethod.GET)
    public ResponseDto<Void> bannerClickRecord(@CookieValue("userInfo") String userInfo, @RequestParam("bannerId") Long bannerId) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        ParamChecker.checkNumberIsNull(bannerId, "参数缺失！");
        appletBannerBiz.bannerClickRecord(wechatUserId, bannerId);
        return new ResponseDto<>();
    }
}



