package com.pcloud.book.giftcoupon.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.applet.dto.AppletNewsCategoryDTO;
import com.pcloud.book.applet.entity.AppletThirdResources;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class GiftPackageDTO{

    /**
     *主键id
     */
    private Long id;
    /**
     * 封面图
     */
    private String coverPic;
    /**
     * 名称
     */
    private String title;
    /**
     * 有效期开始时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date validDateBegin;
    /**
     * 有效期结束时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date validDateEnd;
    /**
     * 面额
     */
    private Integer denomination;

    private Integer stock;
    /**
     * 每人领取上限
     */
    private Integer receiveLimit;

    /**
     * (1-未开始，2-进行中，3-已结束,4-未结束)
     */
    private Integer state;
    /**
     * 领取数量
     */
    private Integer receiveNum;

    /**
     * 未使用数量
     */
    private Integer notUsedNum;

    /**
     * 券类型（2-书币券，1-课程券）
     */
    private Integer couponType;
    /**
     * 使用说明
     */
    private String instructions;

    /**
     * 课程券使用方式（1-链接兑取，2-复制码）
     */
    private Integer useType;
    /**
     * 兑换地址
     */
    private String exchangeAddress;
    /**
     * 跳转外链编号
     */
    private String urlNumber;
    /**
     * 使用量
     */
    private Integer useNum;
    /**
     * 点击量pv/uv
     */
    private String clickPVUV;

    /**
     * 资源编号
     */
    private String resourceNumber;

    /**
     * 资源价格
     */
    private String price;

    /**
     * 资源描述
     */
    private String resourceDesc;

    /**
     * 划线价
     */
    private String crossedPrice;

    /**
     * 是否推荐到首页
     */
    private Boolean recToPage;

    /**
     * 作品还是应用
     */
    private String serveType;

    /**
     * 应用或者作品id
     */
    private Long serveId;

    private String linkUrl;

    /**
     * 第三方资源链接id
     */
    private Long thirdResourceId;


    /**
     * 资源描述返回数组
     */
    private List<String> desc;

    /**
     * 作品或者应用信息
     */
    private ServeInfoDTO serveInfoDTO;

    /**
     * 课程券第三方链接对象
     */
    private AppletThirdResources appletThirdResources;

    /**
     * 是否上架
     */
    private Boolean onShelves;

    @ApiModelProperty("适用类型")
    private List<GiftCategoryDTO> categoryList;

    /**
     * 使用时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm",
            timezone = "GMT+8"
    )
    private Date useTime;

    /**
     * 领取id
     */
    private Long receiveId;

    /**
     * 失效状态 (1-已使用，2-已过期)
     */
    private Integer failureState;

    @ApiModelProperty("是否领取过")
    private Boolean hasReceived;

    private Long agentId;

}
