package com.pcloud.book.rightsSetting.dao;

import com.pcloud.book.rightsSetting.entity.RightsSettingItemDetail;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * (RightsSettingItemDetail)表数据库访问层
 *
 * @author makejava
 * @since 2020-05-18 22:28:12
 */
public interface RightsSettingItemDetailDao extends BaseDao<RightsSettingItemDetail> {

    void deleteByItemIds(List<Long> rightsSettingItemIds);

    List<RightsSettingItemDetail> getByItemIds(List<Long> itemIds);

    List<Long> getAdviserGroupIds(List<Long> ids);

    List<Long> getActivityGroupIds(List<Long> ids);

    /**
     * 删除无效的资讯
     *
     * @param newsIds
     */
    void deleteInvalidNews(List<Long> newsIds);

    /**
     * 根据资讯id查询
     *
     * @param newsIds
     * @return
     */
    List<RightsSettingItemDetail> getByNewsIds(List<Long> newsIds);

    /**
     * 获取社群关联了多少权益
     * @param newArrayList
     * @return
     */
    List<RightsSettingItemDetail> getByActivityIds(List<Long> newArrayList);

    /**
     * 删除无效的模板群
     * @param activityIds
     */
    void deleteInvalidActivityGroups(List<Long> activityIds);
}