package com.pcloud.book.weixinclock.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import io.swagger.annotations.ApiModelProperty;

/**
 * @author 杨涛
 * @description 微信打卡
 * @date 2019/8/14 19:49
 */
public class WeixinClock extends BaseEntity {

    private static final long serialVersionUID = 5405036821243584401L;

    @ApiModelProperty("weixinClockId")
    private Long weixinClockId;

    @ApiModelProperty("打卡关键词")
    private String clockKeyword;

    @ApiModelProperty("打卡引导语")
    private String clockGuide;

    @ApiModelProperty("打卡简介")
    private String clockIntroduction;

    @ApiModelProperty("打卡奖励ID")
    private Long clockPrizeId;

    @ApiModelProperty("打卡奖励URL")
    private String clockPrizeUrl;

    @ApiModelProperty("是否开启优惠券奖励")
    private Integer isOpenCoupon;

    @ApiModelProperty("是否开启打卡抽奖")
    private Integer isOpenPrize;

    @ApiModelProperty("创建人")
    private Long createUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createDate;

    @ApiModelProperty("最近修改人")
    private Long lastModifiedUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("最近修改时间")
    private Date lastModifiedDate;

    public Long getWeixinClockId() {
        return weixinClockId;
    }

    public void setWeixinClockId(Long weixinClockId) {
        this.weixinClockId = weixinClockId;
    }

    public String getClockKeyword() {
        return clockKeyword;
    }

    public void setClockKeyword(String clockKeyword) {
        this.clockKeyword = clockKeyword;
    }

    public String getClockGuide() {
        return clockGuide;
    }

    public void setClockGuide(String clockGuide) {
        this.clockGuide = clockGuide;
    }

    public String getClockIntroduction() {
        return clockIntroduction;
    }

    public void setClockIntroduction(String clockIntroduction) {
        this.clockIntroduction = clockIntroduction;
    }

    public Long getClockPrizeId() {
        return clockPrizeId;
    }

    public void setClockPrizeId(Long clockPrizeId) {
        this.clockPrizeId = clockPrizeId;
    }

    public String getClockPrizeUrl() {
        return clockPrizeUrl;
    }

    public void setClockPrizeUrl(String clockPrizeUrl) {
        this.clockPrizeUrl = clockPrizeUrl;
    }

    public Integer getIsOpenCoupon() {
        return isOpenCoupon;
    }

    public void setIsOpenCoupon(Integer isOpenCoupon) {
        this.isOpenCoupon = isOpenCoupon;
    }

    public Integer getIsOpenPrize() {
        return isOpenPrize;
    }

    public void setIsOpenPrize(Integer isOpenPrize) {
        this.isOpenPrize = isOpenPrize;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Long getLastModifiedUser() {
        return lastModifiedUser;
    }

    public void setLastModifiedUser(Long lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    public Date getLastModifiedDate() {
        return lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    @Override
    public String toString() {
        return "WeixinClock{" +
                "weixinClockId=" + weixinClockId +
                ", clockKeyword='" + clockKeyword + '\'' +
                ", clockGuide='" + clockGuide + '\'' +
                ", clockIntroduction='" + clockIntroduction + '\'' +
                ", clockPrizeId=" + clockPrizeId +
                ", clockPrizeUrl='" + clockPrizeUrl + '\'' +
                ", createUser=" + createUser +
                ", createDate=" + createDate +
                ", lastModifiedUser=" + lastModifiedUser +
                ", lastModifiedDate=" + lastModifiedDate +
                '}';
    }
}
