package com.pcloud.book.keywords.facade;

import com.pcloud.book.keywords.entity.SelfRobotKeyword;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Api(description = "个人号关键词")
public interface SelfRobotKeywordFacade {


    @ApiOperation("批量新增个人号关键词")
    @PostMapping("batchAddSelfRobotKeyword")
    ResponseDto<?> batchAddSelfRobotKeyword(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("个人号关键词") List<SelfRobotKeyword> selfRobotKeywords
    ) throws BizException, PermissionException;

    @ApiOperation("更新个人号关键词")
    @PostMapping("updateSelfRobotKeyword")
    ResponseDto<?> updateSelfRobotKeyword(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("个人号关键词") SelfRobotKeyword selfRobotKeyword
    ) throws BizException, PermissionException;

    @ApiOperation("删除个人号关键词")
    @GetMapping("deleteSelfRobotKeyword")
    ResponseDto<?> deleteSelfRobotKeyword(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("个人号关键词id") Long id
    ) throws BizException, PermissionException;

    @ApiOperation("获取个人号关键词列表")
    @GetMapping("getSelfRobotKeywordList")
    ResponseDto<?> getSelfRobotKeywordList(
            @RequestHeader("token") String token,
            @RequestParam("bookGroupId") @ApiParam("社群码id") Long bookGroupId,
            @RequestParam(value = "keyword",required = false) @ApiParam("关键词") String keyword,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("客户端获取个人号关键词列表")
    @GetMapping("getSelfRobotKeywordList4Wechat")
    ResponseDto<?> getSelfRobotKeywordList4Wechat(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("bookGroupId") @ApiParam("社群码id") Long bookGroupId,
            @RequestParam(value = "keyword",required = false) @ApiParam("关键词") String keyword,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("修改个人号关键词排序值")
    @PostMapping("updateSelfRobotKeywordSeqNum")
    ResponseDto<?> updateSelfRobotKeywordSeqNum(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("个人号关键词") SelfRobotKeyword selfRobotKeyword
    ) throws BizException, PermissionException;

    @ApiOperation("获取应用或作品链接")
    @GetMapping("getAppOrProductServeUrl")
    ResponseDto<?> getAppOrProductServeUrl(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("bookGroupId") @ApiParam("社群码id") Long bookGroupId,
            @RequestParam("serveId") @ApiParam("作品或应用id") Long serveId,
            @RequestParam("serveType") @ApiParam("作品或应用类型") String serveType,
            @RequestParam("serveUrl") @ApiParam("作品或应用链接") String serveUrl
    ) throws BizException, PermissionException;

    /* 个人号H5聚合页面 */
    @ApiOperation("根据类型获取引导语列表")
    @GetMapping("getGuideWordListByType")
    ResponseDto<?> getGuideWordListByType(
            @RequestParam("type") @ApiParam("技能类型") Integer type,
            @RequestParam(value = "labelId",required = false) @ApiParam("分类标签id") Long labelId,
            @RequestParam(value = "wxUserId",required = false) @ApiParam("微信用户id") String wxUserId
    ) throws BizException, PermissionException;

    @ApiOperation("根据类型获取标签列表")
    @GetMapping("listLabelByType")
    ResponseDto<?> listLabelByType(
            @RequestParam("type") @ApiParam("技能类型") Integer type
    ) throws BizException, PermissionException;

    @ApiOperation("根据标签获取引导语列表")
    @GetMapping("getReplyByLabel")
    ResponseDto<?> getReplyByLabel(
            @RequestParam("type") @ApiParam("技能类型") Integer type, Long labelId, String robotId, String wxUserId
    ) throws BizException, PermissionException;

    @ApiOperation("根据关键词获取回复")
    @GetMapping("getReplyByKeyWord")
    ResponseDto<?> getReplyByKeyWord(
            @RequestParam("keyWord") @ApiParam("关键词") String keyWord,
            @RequestParam("type") @ApiParam("技能类型") Integer type,
            @RequestParam("robotId") @ApiParam("小号WXID") String robotId,
            @RequestParam("wxUserId") @ApiParam("用户WXID") String wxUserId
    ) throws BizException, PermissionException;

    @ApiOperation(value = "根据引导语获取任务列表", httpMethod = "GET")
    @GetMapping("getReplyByGuide")
    ResponseDto<?> getReplyByGuide(Integer type, Integer id, String robotId, String wxUserId);

    @ApiOperation(value = "根据任务id获取任务详情", httpMethod = "GET")
    @GetMapping("getSkillDetail")
    ResponseDto<?> getSkillDetail(Integer type, Integer relSkillId,String wxUserId);

    @ApiOperation(value = "确认任务", httpMethod = "GET")
    @GetMapping("confirmSkill")
    ResponseDto<?> confirmSkill(Integer id,Integer type,Integer relSkillId, String robotId, String wxUserId);


    @ApiOperation(value = "", httpMethod = "GET")
    @GetMapping("getResource")
    ResponseDto<?> getResource(Integer id, String robotId, String wxUserId);

    @ApiOperation(value = "进群", httpMethod = "GET")
    @GetMapping("joinGroup")
    ResponseDto<?> joinGroup(Integer id, String robotId, String wxUserId);

    @ApiOperation(value = "用户点击引导语未操作时，主动回复", httpMethod = "GET")
    @GetMapping("sendWhenNoReply")
    ResponseDto<?> sendWhenNoReply(Integer id, String robotId, String wxUserId);

    @ApiOperation("获取个人号图书信息记录列表")
    @GetMapping("getSelfRobotBookRecordList")
    ResponseDto<?> getSelfRobotBookRecordList(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("书刊信息收录导出")
    @GetMapping("exportSelfRobotBookRecord")
    ResponseDto<?> exportSelfRobotBookRecord(@RequestHeader("token") String token) throws BizException, PermissionException;

    @ApiOperation("getById")
    @GetMapping("getById")
    ResponseDto<?> getById(String token, Long id);
}
