package com.pcloud.book.pcloudkeyword.biz.impl;

import com.pcloud.book.pcloudkeyword.biz.PcloudKeywordBiz;
import com.pcloud.book.pcloudkeyword.biz.PcloudKeywordClassifyBiz;
import com.pcloud.book.pcloudkeyword.dao.PcloudKeywordClassifyDao;
import com.pcloud.book.pcloudkeyword.dto.PcloudKeywordClassifyDTO;
import com.pcloud.book.pcloudkeyword.entity.PcloudKeywordClassify;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("pcloudKeywordClassifyBiz")
public class PcloudKeywordClassifyBizImpl implements PcloudKeywordClassifyBiz {

    @Autowired
    private PcloudKeywordClassifyDao pcloudKeywordClassifyDao;
    @Autowired
    private PcloudKeywordBiz pcloudKeywordBiz;

    @Override
    public Long insert(PcloudKeywordClassify pcloudKeywordClassify) {
        pcloudKeywordClassifyDao.insert(pcloudKeywordClassify);
        Long id = pcloudKeywordClassify.getId();
        return id;
    }

    @Override
    public void update(PcloudKeywordClassify pcloudKeywordClassify) {
        pcloudKeywordClassifyDao.update(pcloudKeywordClassify);
    }

    @Override
    public void deleteById(Long id) {
        pcloudKeywordClassifyDao.setDeleteById(id);
        //删除关键词
        pcloudKeywordBiz.deleteByKeywordClassifyId(id);
    }

    @Override
    public void updateOpenStateById(Long id, Boolean open) {
        pcloudKeywordClassifyDao.updateOpenById(id, open);
    }

    @Override
    public List<PcloudKeywordClassifyDTO> list(String classify){
        List<PcloudKeywordClassifyDTO> list = pcloudKeywordClassifyDao.list(classify);
        return list;
    }
}
