package com.pcloud.book.pcloudkeyword.dao.impl;

import com.pcloud.book.pcloudkeyword.dao.PcloudNotKeywordDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudNotKeyword;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("pcloudNotKeywordDao")
public class PcloudNotKeywordDaoImpl extends BaseDaoImpl<PcloudNotKeyword> implements PcloudNotKeywordDao {

    @Override
    public List<Long> getIdsByClassifyId(Long keywordClassifyId) {
        return getSessionTemplate().selectList(getStatement("getIdsByClassifyId"), keywordClassifyId);
    }

    @Override
    public void deleteByClassifyId(Long keywordClassifyId) {
        getSessionTemplate().delete(getStatement("deleteByClassifyId"), keywordClassifyId);
    }

    @Override
    public List<PcloudNotKeyword> getPcloudNotKeywordList(Long keywordClassifyId) {
        Map<String,Object> map = new HashMap<>();
        map.put("keywordClassifyId", keywordClassifyId);
        return getSessionTemplate().selectList(getStatement("getPcloudNotKeywordList"), map);
    }
}
