package com.pcloud.book.timecontrol.mapper;

import com.pcloud.book.timecontrol.entity.TimeControlTaskSend;
import com.pcloud.book.timecontrol.dto.TaskSendDto;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @date: 2020年01月31日 20:05
 * @Author: Zcy
 * @Descprition
 */
@Component
public interface TimeControlTaskSendMapper {

    void batchInsert(List<TimeControlTaskSend> taskSendList);

    List<TaskSendDto> listTodayTask();

    void cancelSend(@Param("subscribeId") Integer subscribeId, @Param("sendState") Integer sendState);

    void cancelSendByTaskId(Integer taskId);

    void cancelSendByItemId(Integer taskItemId);

    /**
     * 查询已发送消息数
     */
    Integer countMsgSend(@Param("taskId") Integer taskId, @Param("bookId") Integer bookId);

    /**
     * 查询今日未发送消息数
     */
    Integer countTodayNotSend(@Param("taskId") Integer taskId, @Param("bookId") Integer bookId, @Param("sendDay") String sendDay);

    void updateSendState(@Param("sendId") Integer sendId, @Param("sendState") Integer sendState, @Param("completeState") Integer completeState);

    TimeControlTaskSend getById(Integer taskSendId);

    Integer getNoCompletedItem(Integer taskId);
}
