package com.pcloud.book.timecontrol.mapper;

import com.pcloud.book.timecontrol.entity.TimeControlTaskSubscribe;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

/**
 * @date: 2020年01月31日 20:05
 * @Author: Zcy
 * @Descprition
 */
@Component("taskSubscribeMapper")
public interface TimeControlTaskSubscribeMapper {

    void subscribeTask(TimeControlTaskSubscribe timeControlTaskSubscribe);

    TimeControlTaskSubscribe getSubscribe(@Param("wxUserId") String wxUserId, @Param("bookId") Long bookId, @Param("taskId") Integer taskId);

    void subscribeTaskExist(TimeControlTaskSubscribe taskSubscribe);

    void unSubscribeTask(TimeControlTaskSubscribe taskSubscribe);

    void unSubscribeTaskByTaskId(Integer taskId);

    /**
     * 查询任务订阅人数
     */
    Integer countTaskSubscribe(@Param("taskId") Integer taskId, @Param("bookId") Integer bookId);

    TimeControlTaskSubscribe getById(Integer subscribeId);

    void completedTaskById(Integer subscribeId);


}
