package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * (AppletNewsServe)实体类
 *
 * @author makejava
 * @since 2020-06-30 16:56:08
 */
@Data
public class AppletNewsServeDTO extends BaseDto {

    private Long id;
    
    @ApiModelProperty("资讯id")
    private Long appletNewsId;
    
    @ApiModelProperty("标题")
    private String title;
    
    @ApiModelProperty("导图")
    private String picUrl;
    
    @ApiModelProperty("跳转地址")
    private String linkUrl;
    
    @ApiModelProperty("服务id")
    private Long serveId;
    
    @ApiModelProperty("服务类型，1：applet；2：第三方资讯；")
    private Integer serveType;
    
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("小程序id")
    private String appletsId;

    @ApiModelProperty("小程序宣传语")
    private String slogan;

    @ApiModelProperty("小程序宣传图片")
    private String sloganImgUrl;

    @ApiModelProperty("小程序访问地址")
    private String appletsUrl;

    @ApiModelProperty("小程序备注")
    private String remark;

}
