package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.entity.ServeCollect;
import com.pcloud.common.page.PageBeanNew;

import java.util.ArrayList;
import java.util.List;

/**
 * (ServeCollect)表服务接口
 *
 * @author makejava
 * @since 2020-09-10 10:44:31
 */
public interface ServeCollectBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    ServeCollect getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Long wechatUserId, Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param serveCollect 实例对象
     * @return 主键
     */
    Long insert(ServeCollect serveCollect);

    /**
     * 修改数据
     *
     * @param serveCollect 实例对象
     */
    void update(ServeCollect serveCollect);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    /**
     * 批量取消关注
     */
    void cancelCollect(List<Long> ids);

    /**
     * 删除无效的资讯
     * @param newArrayList
     */
    void deleteInvalidNews(List<Long> newArrayList);

    /**
     * 查询是否是否存在
     * @param serveCollects
     * @return
     */
    List<ServeCollect> getList4RightsSetting(List<ServeCollect> serveCollects);


    /**
     * 获取所有的收藏id
     * @param wechatUserId
     * @return
     */
    List<Long> getAllCollect(Long wechatUserId);
}