package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.ServeCollectDao;
import com.pcloud.book.applet.entity.ServeCollect;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * (ServeCollect)表数据库访问层
 *
 * @author makejava
 * @since 2020-09-10 10:44:31
 */
@Repository("serveCollectDaoImpl")
public class ServeCollectDaoImpl extends BaseDaoImpl<ServeCollect> implements ServeCollectDao {

    @Override
    public void cancelCollect(List<Long> ids) {
        getSessionTemplate().update(getStatement("cancelCollect"), ids);
    }

    @Override
    public void deleteInvalidNews(List<Long> newsIds) {
        getSessionTemplate().update(getStatement("deleteInvalidNews"), newsIds);
    }

    @Override
    public List<ServeCollect> getList4RightsSetting(List<ServeCollect> serveCollects) {
        return getSessionTemplate().selectList(getStatement("getList4RightsSetting"), serveCollects);
    }

    @Override
    public List<Long> getAllCollect(Long wechatUserId) {
        return getSessionTemplate().selectList(getStatement("getAllCollect"), wechatUserId);
    }
}