package com.pcloud.book.cultivate.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.cultivate.entity.CultivateNotifyItem;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class CultivateNotifyDTO {
    @ApiModelProperty("消息类型（1-系统消息，2-通知消息，3-提醒消息，4-活动消息）")
    private Integer messageType;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("消息id")
    private Long messageId;

    @ApiModelProperty("个人号分类id")
    private Long classifyId;

    @ApiModelProperty("个人号wxId")
    private String wxId;

    @ApiModelProperty("bookId")
    private Long bookId;

    @ApiModelProperty("发送类型（1-指定用户，2-分类用户，3-按书籍查询，4-全局公告消息）")
    private Integer sendType;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date sendTime;

    @ApiModelProperty("发送内容")
    private List<CultivateNotifyItem> cultivateNotifyItems;

    @ApiModelProperty("用户id")
    private List<WechatUserDTO> wechatUserDTOS;

    @ApiModelProperty("出版社id")
    private Long agentId;
}
