package com.pcloud.book.mq.topic;

import com.pcloud.book.clock.dao.BookClockInfoDao;
import com.pcloud.book.keywords.dao.BookGuideReplyDao;
import com.pcloud.book.keywords.dao.KeywordDao;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.resourcecenter.product.entity.Product;

import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author lily
 * @date 2019/6/6 11:10
 */
@Component
@RabbitListener(queues = MQTopicConumer.PRODUCT_UPDATE)
public class ProductUpdateListener {

    @Autowired
    private KeywordDao keywordDao;

    @Autowired
    private BookGuideReplyDao bookGuideReplyDao;

    @Autowired
    private BookClockInfoDao bookClockInfoDao;

    /**
     * 接收资源中心消息
     */
    @RabbitHandler
    @ParamLog("接收商品修改消息")
    public void onMessage(Product product) throws BizException {
        if (product == null) {
            return;
        }
        keywordDao.updateServeInfo(product.getProductId(), "PRODUCT", product.getProductName(), product.getCoverImg());
        bookGuideReplyDao.updateServeInfo(product.getProductId(), "PRODUCT", product.getProductName(), product.getCoverImg());
        bookClockInfoDao.updateProductInfo(product.getProductId(),product.getProductName(),product.getCoverImg(),product.getUniqueNumber());
    }
}
