package com.pcloud.book.cultivate.dto;

import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName com.pcloud.book.cultivate.dto.NotifySendDTO
 * @Author zhuyajie
 * @Description 小程序消息发送
 * @Date 2021/7/14 14:39
 * @Version 1.0
 **/
@Data
public class NotifySendDTO {


    @ApiModelProperty("用户微信id")
    private Long wechatUserId;

    @ApiModelProperty("发送类型（1-指定用户，2-分类用户，3-按书籍查询，4-全局公告消息）")
    private Integer sendType;

    @ApiModelProperty("消息类型（1-系统消息，2-通知消息，3-提醒消息，4-活动消息 5-更多消息）")
    private Integer messageType;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("消息详情")
    private List<NotifyItemDTO> notifyItemDTOS;
}
