package com.pcloud.book.advertising.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;
import java.util.List;

/**
 * 报名记录选项内容
 */
public class AdvertisingBmRegisterItem extends BaseEntity{

    /**
     *用户id
     */
    private Long userId;
    /**
     *广告id
     */
    private Long adId;
    /**
     *报名记录ID
     */
    private Long registerId;
    /**
     *选项ID
     */
    private Long optionId;
    /**
     *选项清单ID
     */
    private Long optionItemId;
    /**
     *选项值
     */
    private String optionValue;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;
    /**
     * 选项清单IDs,单选多选
     */
    private List<Long> optionItemIds;

    /**
     * cpa内容id
     */
    private Long cpaId;

    public Long getCpaId() {
        return cpaId;
    }

    public void setCpaId(Long cpaId) {
        this.cpaId = cpaId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public Long getRegisterId() {
        return registerId;
    }

    public void setRegisterId(Long registerId) {
        this.registerId = registerId;
    }

    public Long getOptionId() {
        return optionId;
    }

    public void setOptionId(Long optionId) {
        this.optionId = optionId;
    }

    public Long getOptionItemId() {
        return optionItemId;
    }

    public void setOptionItemId(Long optionItemId) {
        this.optionItemId = optionItemId;
    }

    public String getOptionValue() {
        return optionValue;
    }

    public void setOptionValue(String optionValue) {
        this.optionValue = optionValue == null ? null : optionValue.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public List<Long> getOptionItemIds() {
        return optionItemIds;
    }

    public void setOptionItemIds(List<Long> optionItemIds) {
        this.optionItemIds = optionItemIds;
    }

    @Override
    public String toString() {
        return "AdvertisingBmRegisterItem{" +
                "userId=" + userId +
                ", adId=" + adId +
                ", registerId=" + registerId +
                ", optionId=" + optionId +
                ", optionItemId=" + optionItemId +
                ", optionValue='" + optionValue + '\'' +
                ", createTime=" + createTime +
                ", optionItemIds=" + optionItemIds +
                '}';
    }
}